local sealevel = pmb_underworld.sea_level
local alt_max = pmb_underworld.alt_max
local alt_min = pmb_underworld.alt_min

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = pmb_underworld.get_schematic_path


minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:underworld"},
    sidelen = 80,
    -- fill_ratio = 0.0005,
    noise_params = {
      offset  = 0,
      scale   = 0.00002,
      spread  = {x=3, y=3, z=3},
      seed    = 7852,
      octaves = 4,
      persist = 1,
      lacunarity = 1,
      flags = "defaults",
    },
    biomes = {"underworld_mythril_towers"},
    y_min        = sealevel,
    y_max        = alt_max,
    schematic = sch("mythril_tower_1"),
    flags = "all_floors, force_placement, place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -40
  })
  
  minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:underworld"},
    sidelen = 80,
    -- fill_ratio = 0.0005,
    noise_params = {
      offset  = 0,
      scale   = 0.00012,
      spread  = {x=3, y=3, z=3},
      seed    = 7851,
      octaves = 4,
      persist = 1,
      lacunarity = 1,
      flags = "defaults",
    },
    biomes = {"underworld_mythril_towers"},
    y_min        = sealevel,
    y_max        = alt_max,
    schematic = sch("mythrite_lamppost_1"),
    flags = "all_floors, force_placement, place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -1
  })
  minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:underworld"},
    sidelen = 80,
    -- fill_ratio = 0.0005,
    noise_params = {
      offset  = 0,
      scale   = 0.00012,
      spread  = {x=3, y=3, z=3},
      seed    = 7850,
      octaves = 4,
      persist = 1,
      lacunarity = 1,
      flags = "defaults",
    },
    biomes = {"underworld_mythril_towers"},
    y_min        = sealevel,
    y_max        = alt_max,
    schematic = sch("mythril_house_1"),
    flags = "all_floors, force_placement, place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = -4
  })