local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_craftitem("pmb_food:wooden_bowl_mushroom_soup", {
    description = S("Mushroom Soup"),
    inventory_image = "pmb_wooden_bowl.png^pmb_mushroom_soup.png",
    groups = { item_wooden_bowl_mushroom_soup = 1, craftitem = 1, soup = 1, },
})
pmb_util.register_wield_use_delay("pmb_food:wooden_bowl_mushroom_soup", {
    windup = 2,
    sound = pmb_food.sound.gulp({gain=0.2}),
    sound_per_sec = 2,
    on_use = pmb_food.eat({
        ["regeneration_3"] = 3*4+1,
        ["regeneration_8"] = 8*4+1,
    }, "pmb_items:wooden_bowl", pmb_food.sound.gulp())
})

pmb_tcraft.register_craft({
    output = "pmb_food:wooden_bowl_mushroom_soup",
    items = {
        ["pmb_items:wooden_bowl"] = 1,
        ["pmb_flora:mushroom_white"] = 1,
        ["pmb_flora:mushroom_red"] = 1,
    }
})
pmb_tcraft.register_craft({
    output = "pmb_food:wooden_bowl_mushroom_soup",
    items = {
        ["pmb_items:wooden_bowl"] = 1,
        ["pmb_flora:mushroom_white"] = 1,
        ["pmb_flora:mushroom_brown"] = 1,
    }
})
pmb_tcraft.register_craft({
    output = "pmb_food:wooden_bowl_mushroom_soup",
    items = {
        ["pmb_items:wooden_bowl"] = 1,
        ["pmb_flora:mushroom_brown"] = 1,
        ["pmb_flora:mushroom_red"] = 1,
    }
})

minetest.register_alias("pmb_items:wooden_bowl_mushroom_soup", "pmb_food:wooden_bowl_mushroom_soup")


-- pumpkin soup
minetest.register_craftitem("pmb_food:wooden_bowl_pumpkin_soup", {
    description = S("Pumpkin Soup"),
    inventory_image = "pmb_wooden_bowl.png^pmb_pumpkin_soup.png",
    groups = { item_wooden_bowl_pumpkin_soup = 1, craftitem = 1, soup = 1, },
})
pmb_util.register_wield_use_delay("pmb_food:wooden_bowl_pumpkin_soup", {
    windup = 2,
    sound = pmb_food.sound.gulp({gain=0.2}),
    sound_per_sec = 2,
    on_use = pmb_food.eat({
        ["regeneration_3"] = 3*4+1,
        ["regeneration_8"] = 8*4+1,
    }, "pmb_items:wooden_bowl", pmb_food.sound.gulp())
})
pmb_tcraft.register_craft({
    output = "pmb_food:wooden_bowl_pumpkin_soup",
    items = {
        ["pmb_items:wooden_bowl"] = 1,
        ["pmb_food:pumpkin_cooked"] = 1,
    }
})


minetest.register_craftitem("pmb_food:glowroot_soup", {
    description = S("Glowroot Soup"),
    inventory_image = "pmb_wooden_bowl.png^pmb_glowroot_soup.png",
    groups = { item_baked_potato = 1, craftitem = 1, },
})
pmb_util.register_wield_use_delay("pmb_food:glowroot_soup", {
    windup = 2,
    sound = pmb_food.sound.gulp({gain=0.2}),
    sound_per_sec = 2,
    on_use = pmb_food.eat({
        ["regeneration_8"] = 8*4+1,
        ["glowing_12"] = 120,
    }, "pmb_items:wooden_bowl", pmb_food.sound.gulp({gain=0.2}))
})

pmb_tcraft.register_craft({
    output = "pmb_food:glowroot_soup",
    extra_items = {
        "pmb_items:wooden_cup",
    },
    items = {
        ["pmb_items:wooden_bowl"] = 1,
        ["pmb_items:wooden_cup_water"] = 1,
        ["pmb_flora:glowroot"] = 1,
    }
})
