local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

local size = 20

local biomes = {
    "grasslands",
    "grasslands_valley",
    "oak_forest_dense_1",
    "oak_forest_dense",
    "oak_forest",
    "tundra",
}

local function do_pumpkin_stuff(seed)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"group:topsoil"}, -- only on grasslike nodes
        sidelen = 2,
        noise_params = {
            offset = -0.6,
            scale = 0.36,
            spread = {x = size, y = size, z = size},
            seed = seed,
            octaves = 3,
            persist = 0.9,
            lucanarity = 1.7,
        },
        biomes = biomes,
        y_max = alt_max,
        y_min = sealevel + 1,
        decoration = "pmb_flora:pumpkin",
    })
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"group:topsoil"}, -- only on grasslike nodes
        sidelen = 2,
        noise_params = {
            offset = -3.9,
            scale = 2.4,
            spread = {x = size, y = size, z = size},
            seed = seed,
            octaves = 3,
            persist = 0.9,
            lucanarity = 1.7,
        },
        biomes = biomes,
        y_max = alt_max,
        y_min = sealevel + 1,
        decoration = "pmb_flora:pumpkin_plant_inactive",
    })
end


do_pumpkin_stuff(89)
