local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local fern_box = {
    type = "fixed",
    fixed = {
        -6/16, -8/16, -6/16,
        6/16, 2/16, 6/16,
    }
}

local function register_fern(node_name, tiles)
    local name = string.lower(node_name)
    minetest.register_node('pmb_flora:' .. name, {
        description = pmb_util.desc(S("Some fern"), "grey"),
        drawtype = "plantlike",
        walkable = false,
        waving = 1,
        paramtype = "light",
        inventory_image = "pmb_" .. name .. ".png",
        wield_image = "pmb_" .. name .. ".png",
        is_ground_content = true,
        sunlight_propagates = true,
        selection_box = fern_box,
        groups = { nature = 1, attached_node = 1, item_fern = 1, dig_immediate = 3, flora = 1, },
        drop = pmb_flora.grass_drops,
        tiles = tiles,
        buildable_to = true,
        sounds = pmb_sounds.default_plant(),
        on_place = function(itemstack, placer, pointed_thing)
            return pmb_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
    })
end

register_fern("fern_0", {"pmb_fern_0.png"})
register_fern("fern_1", {"pmb_fern_1.png"})
-- register_fern("fern_2", {"pmb_fern_2.png"})
-- register_fern("fern_3", {"pmb_fern_3.png"})
