
local tier_color = {
    "#eeeeee", -- 1, grey
    "#6dd69d", -- 2, green
    "#66aaff", -- 3, blue
    "#ffff99", -- 4, yellow
    "#ff4422", -- 5, red
    "#a744ff", -- 6, purple
    "#1a2183", -- 7, deep blue
}

-- description
tt.register_snippet(function(itemstring, def)
    return def.description, tier_color[def._tt_color] or def._tt_color or "#eee"
end)

-- _tt_long_desc
tt.register_snippet(function(itemstring, def)
    local item = minetest.registered_items[itemstring]
    return item._tt_long_desc, "#dddddd"
end)

-- _tt_how_to_use
tt.register_snippet(function(itemstring, def)
    local item = minetest.registered_items[itemstring]
    return item._tt_how_to_use, "#aaaaaa"
end)

-- _tt_uses
tt.register_snippet(function(itemstring, def)
    local item = minetest.registered_items[itemstring]
    if not item._tt_uses then return end
    return item._tt_uses.." total uses", "#eeee33"
end)

-- _tt_uses
tt.register_snippet(function(itemstring, def)
    return "\n"..itemstring, "#aaaaaa"
end)

--[[
description = pmb_util.desc(S("NAMEHERE"), "grey"),
_tt_long_desc = S("LONGDESC"),
_tt_how_to_use = S("HOWTOUSE").."\n"..S("SOMETHINGELSE"),
_tt_uses = SOMENUMBER,
]]--