local sealevel = pmb_mirecaves.sea_level
local alt_max = pmb_mirecaves.alt_max
local alt_min = pmb_mirecaves.alt_min

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = pmb_mirecaves.get_schematic_path

for i=0, 5 do
    for j=1, 2 do
        minetest.register_decoration({
            deco_type = "schematic",
            place_on = {"group:mirecaves", "pmb_mirecaves:nolmer"},
            sidelen = 80,
            -- fill_ratio = 0.0005,
            noise_params = {
            offset  = 0,
            scale   = 0.0001,
            spread  = {x=3, y=3, z=3},
            seed    = 7852+i*3,
            octaves = 4,
            persist = 1,
            lacunarity = 1,
            flags = "defaults",
            },
            y_min        = alt_min,
            y_max        = alt_max,
            schematic = sch("nolmer_1"),
            flags = "all_floors, force_placement, place_center_x, place_center_z",
            rotation = "random",
            place_offset_y = 0
        })
        minetest.register_decoration({
            deco_type = "schematic",
            place_on = {"group:mirecaves", "pmb_mirecaves:nolmer"},
            sidelen = 80,
            -- fill_ratio = 0.0005,
            noise_params = {
            offset  = 0,
            scale   = 0.0002,
            spread  = {x=3, y=3, z=3},
            seed    = 453+i,
            octaves = 4,
            persist = 1,
            lacunarity = 1,
            flags = "defaults",
            },
            y_min        = alt_min,
            y_max        = alt_max,
            schematic = sch("nolmer_2"),
            flags = "all_floors, force_placement, place_center_x, place_center_z",
            rotation = "random",
            place_offset_y = 0
        })
    end
end

local function do_nolmer_stuff(name, seed)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"pmb_mirecaves:stone_moss", "pmb_mirecaves:stone"},
        sidelen = 2,
        noise_params = {
            offset = -0.6 - 0.08,
            scale = 0.9,
            spread = {x = 4, y = 4, z = 4},
            seed = seed,
            octaves = 3,
            persist = 0.1
        },
        -- biomes = {""},
        y_max = alt_max,
        y_min = sealevel,
        decoration = "pmb_mirecaves:"..name,
        flags = "all_floors"
    })
end

do_nolmer_stuff("nolmera_1", 43)
do_nolmer_stuff("nolmera_2", 43)


local function do_nolmer_vine_stuff(name, seed)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"pmb_mirecaves:stone_moss", "pmb_mirecaves:stone"},
        height = 1,
        height_max = 9,
        noise_params = {
            offset = -0.2 - 0.08,
            scale = 0.4,
            spread = {x = 12, y = 12, z = 12},
            seed = seed,
            octaves = 1,
            persist = 0.1
        },
        -- biomes = {""},
        y_max = alt_max,
        y_min = sealevel,
        decoration = "pmb_mirecaves:"..name,
        flags = "all_ceilings"
    })
end

do_nolmer_vine_stuff("nolmera_vine_1", 13)
