

local function xyz(param)
    return true
end

local function abc(param)
    return true
end



function  pmb_cooking.cooker_offer_item(pos, itemstack)
    if not itemstack then
        return itemstack end
    local timer = minetest.get_node_timer(pos)
    if not timer:is_started() then
        timer:start(1.0)
    end
    local node = minetest.get_node(pos)
    local def = minetest.registered_nodes[node.name]
    local recipe = pmb_cooking.get_recipe(itemstack:get_name(), def._cook_group(pos))
    if not recipe then
        return itemstack
    end

    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()

    local result = inv:add_item("input", ItemStack(itemstack:get_name()))
    if not result:is_empty() then
        return itemstack
    else
        itemstack:take_item()
        return itemstack
    end
    return itemstack
end


-- on_rightclick to take items out of the cooker
function pmb_cooking.cooker_give_item(pos, node, clicker, itemstack, pointed_thing)
    return pmb_cooking.cooker_offer_item(pos, itemstack)
end

-- on_punch
function pmb_cooking.cooker_take_item(pos, node, clicker, itemstack, pointed_thing)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    local output = inv:get_stack('output', 1)
    local input = inv:get_stack('input', 1)

    -- take stuff from the inv and give to player
    local clicker_inv = clicker:get_inventory()
    if not inv:is_empty('output') then
        local count = output:get_count()
        output = clicker_inv:add_item('main', output)
        inv:set_stack("output", 1, output)
        if count ~= output:get_count() then
            minetest.sound_play("pmb_sounds_pickup", {
              gain = 0.2,
              pos = pos,
              max_hear_distance = 5,
            })
        end
        return itemstack
    elseif not inv:is_empty('input') then
        local count = input:get_count()
        input = clicker_inv:add_item('main', input)
        inv:set_stack("input", 1, input)
        if count ~= input:get_count() then
            minetest.sound_play("pmb_sounds_pickup", {
              gain = 0.2,
              pos = pos,
              max_hear_distance = 5,
            })
        end
        return itemstack
    end
end


-- happens every second, set your on_timer to this
function pmb_cooking.cooker_node_timer(pos, elapsed)
    local node = minetest.registered_nodes[minetest.get_node(pos).name]
    local cook_group
    if type(node._cook_group) == "function" then
        cook_group = node._cook_group(pos)
    else
        cook_group = node._cook_group
    end

    -- minetest.log("thinking")
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()


    -- don't cook if there's no heat
    if not cook_group then return end

    local has_cooked = false

    local itemstack = inv:get_stack("input", 1)
    if not itemstack then return false end
    local cooked

    local recipe = pmb_cooking.get_recipe(itemstack:get_name(), cook_group)
    local timer_elapsed = meta:get_int("timer_elapsed") or 0
    timer_elapsed = timer_elapsed + 1

    if recipe then
        meta:set_int("timer_elapsed", timer_elapsed)
    end

    if (not recipe or not recipe.cook_time)
    or (timer_elapsed < recipe.cook_time) then
        return true
    else
        meta:set_int("timer_elapsed", 0)
    end

    if recipe.cook_time == -1 then
        itemstack, cooked = pmb_cooking.cook(itemstack, cook_group, 999)
    else
        itemstack, cooked = pmb_cooking.cook(itemstack, cook_group, 1)
    end

    if cooked and inv:room_for_item("output", cooked) then
        has_cooked = true
    end

    if has_cooked then
        inv:add_item("output", cooked)
        inv:set_stack("input", 1, itemstack)
        node._on_cook(pos, node)
    end
    return true
end


-- set your node on_construct to this
function pmb_cooking.cooker_on_construct(pos)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    inv:set_size('input', 1)
    inv:set_size('output', 1)
    -- pmb_cooking.cooker_node_timer(pos, 0)
    local timer = minetest.get_node_timer(pos)
    if not timer:is_started() then
        timer:start(1.0)
    end
end
