local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local box = {
    type = "fixed",
    fixed = {
        {
            8/16, 8/16, 8/16, -8/16, 7/16, -8/16,
        },
        {
            8/16, 1/16, 8/16, -8/16, -8/16, -8/16,
        },
    }
}

local function scaffold_collapse(pos, cause, user, count, payload)
    if cause ~= "scaffold_collapse" then return false end
    -- minetest.chat_send_all(count)
    if user and minetest.is_player(user) then
        local name = minetest.get_node(pos).name
        minetest.set_node(pos, {name="air"})
        local inv = user:get_inventory()
        inv:add_item("main", ItemStack(name))
        return true
    end
end

minetest.register_node("pmb_wood:scaffolding", {
    description = pmb_util.desc(S("Scaffolding"), "grey"),
    _tt_long_desc = S("Scaffolding which can be placed and destroyed with ease."),
    groups = { item_scaffolding = 1, dig_immediate = 3, solid = 1, scaffolding = 1 },
    paramtype2 = "4dir",
    tiles = {
        "pmb_scaffolding_top.png",
        "pmb_scaffolding_side.png",
        "pmb_scaffolding_side.png",
    },
    backface_culling = true,
    use_texture_alpha = "opaque",
    sounds = pmb_sounds.default_wood(),
    on_place = function(itemstack, placer, pointed_thing)
        local below_pos = placer:get_pos()
        below_pos.y = below_pos.y - 1
        local is_player = minetest.is_player(placer)

        local facedir = minetest.dir_to_fourdir((minetest.is_player(placer) and placer:get_look_dir()) or vector.new(0,0,1))

        local should_place_normally = false
        if not (pointed_thing.above.y >= pointed_thing.under.y + 1) then
            should_place_normally = true
        end
        if not should_place_normally then
            local ctrl = (is_player and placer:get_player_control()) or {}
            local node_under = minetest.get_node(pointed_thing.under)
            should_place_normally = should_place_normally or (not ctrl.aux1) or node_under.name ~= "pmb_wood:scaffolding"
        end
        if should_place_normally then
            local ret = minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
            return ret
        end

        local dir = is_player and placer:get_look_dir() or vector.new(0,0,1)
        dir.y = 0

        local to_pos = vector.copy(pointed_thing.under)

        for i = 0, 6 do
            to_pos = vector.add(to_pos, dir)
            local node = minetest.get_node(to_pos)
            local def = minetest.registered_nodes[node.name]
            if def and def.buildable_to then
                minetest.dig_node(to_pos)
                minetest.set_node(to_pos, {name=itemstack:get_name()})
                local n = minetest.get_node(to_pos)
                n.param2 = facedir
                minetest.set_node(to_pos, n)
                itemstack:take_item()
                return itemstack
            end
        end
    end,
    -- on_punch = function (pos, node, puncher, pointed_thing)
    --     local ctrl = (minetest.is_player(puncher) and puncher:get_player_control()) or {}
    --     if ctrl.sneak then
    --         if pmb_node_update then
    --             pmb_node_update.update_node_propagate(pos, "scaffold_collapse", puncher, 30)
    --         end
    --     end
    -- end,
    -- _on_node_update = function(pos, cause, user, count, payload)
    --     return scaffold_collapse(pos, cause, user, count, payload)
    -- end,
})
pmb_tcraft.register_craft({
    output = "pmb_wood:scaffolding 4",
    items = {
        ["pmb_items:stick"] = 8,
    },
})



local flat_box = {
    type = "fixed",
    fixed = {
        {
            (-8)/16, (-7.9)/16, (-8/16),
            ( 8)/16, (-7.8)/16, ( 8/16),
        },
    },
}

minetest.register_node('pmb_wood:crude_ladder', {
    description = pmb_util.desc(S("Crude Ladder"), "grey"),
    _tt_long_desc = S("Crude_ladder"),
    groups = { item_crude_ladder = 1, dig_immediate = 3, ladder = 1 },
    drawtype = "signlike",
    -- node_box = flat_box,
    selection_box = flat_box,
    sunlight_propagates = true,
    paramtype2 = "wallmounted",
    paramtype = "light",
    tiles = {
        "pmb_crude_ladder.png",
    },
    walkable = false,
    climbable = true,
    backface_culling = false,
    use_texture_alpha = "clip",
    sounds = pmb_sounds.default_wood(),

    on_place = function(itemstack, placer, pointed_thing)
        local node_under = minetest.get_node(pointed_thing.under)
        if minetest.get_item_group(node_under.name, "full_solid") == 0 then
            return itemstack
        else
            return minetest.item_place_node(itemstack, placer, pointed_thing)
        end
    end,
    _on_node_update = function(pos, cause, user, count, payload)
        local ret = false
        ret = scaffold_collapse(pos, cause, user, count, payload)
        local node = minetest.get_node(pos)
        local mountdir = minetest.wallmounted_to_dir(node.param2)
        local mountnode = minetest.get_node(vector.add(pos, mountdir))
        if (mountdir.y == 1 or mountdir.y == -1) or minetest.get_item_group(mountnode.name, "full_solid") == 0 then
            minetest.dig_node(pos)
            ret = true
        end

        if ret then return true
        else return false end
    end,
})
if true then
    local s = "pmb_items:stick"
    minetest.register_craft({
      output = "pmb_wood:crude_ladder 16",
      recipe = {
        {s,"", s},
        {s, s, s},
        {s,"", s},
      },
    })
end
