local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_tool("pmb_combat:test_sword", {
    description = S("Test Sword"),
    _tt_color = "#fea",
    inventory_image = "pmb_combat_test_sword.png",

    _pmb_combat_get_attack = function(itemstack)
        return {
            base_damage = {
                cut = 5,
                blunt = 2,
            },
            max_base_damage = 5,
            knockback_mult = 4,
        }
    end,
    _on_attack_sent = function(stack, attacker, atk)
        atk.multiplier.cut = (atk.multiplier.cut or 1) * 1.2
        minetest.log("sword used, sent attack and added mults")
        return atk
    end,
    on_secondary_use = function(itemstack, user, pointed_thing)
        if (not user) or not user:is_player() then return itemstack end

        local mode = pmb_combat.cooldown.get_mode(itemstack)
        if mode == "" then
            pmb_combat.attack.declare_blocking(user, 10, function() minetest.log("BLOCKED") return true end)
            minetest.log("blocking start")
            return pmb_combat.cooldown.windup_start(itemstack, user)
        end
    end,
    on_step = function(itemstack, player, dtime)
        local ctrl = player:get_player_control()
        local mode = pmb_combat.cooldown.get_mode(itemstack)

        if (ctrl and not ctrl.dig) then
            if mode == "complete" then
                minetest.log("on sword swing")
                itemstack = pmb_combat.attack.blindly_attack_with_raycast(itemstack, player, 5, nil, nil) or itemstack
                minetest.sound_play(("pmb_fenn_spear_throw"), {
                    gain = 0.9,
                    object = player,
                    max_hear_distance = 50,
                    pitch = (math.random()*0.1) + 0.70
                })
                return pmb_combat.cooldown.cooldown_start(itemstack, player)
            elseif mode == "windup" then
                return pmb_combat.cooldown.cooldown_complete(itemstack, player)
            end
        end
    end,

    on_deselect = function(itemstack, player)
        return pmb_combat.cooldown.cooldown_complete(itemstack, player)
    end,

    on_use = function(itemstack, user, pointed_thing)
        if (not user) or not user:is_player() then return itemstack end
        if pmb_combat.cooldown.can_use(itemstack) then
            return pmb_combat.cooldown.windup_start(itemstack, user)
        end
    end,

    _on_windup_complete = function(itemstack, player)
    end,

    _windup = 0.5,
    _cooldown = 0.0,

    tool_capabilities = {
        full_punch_interval = 1,
    },
    groups = { combat = 1, sword = 1 },
})


minetest.register_tool("pmb_combat:test_pants", {
    description = pmb_util.desc(S("Pants"), "grey"),
    inventory_image = "pmb_combat_test_pants.png",
    _tt_color = "#fea",

    _on_attack_received = function(stack, victim, atk)
        atk.multiplier.cut = (atk.multiplier.cut or 1) * 0.5
        minetest.log("armor used, received attack")
    end,
    on_step = function(itemstack, player, dtime)
    end,
    groups = { combat = 1, armor_legs = 1 },
})



