local function reg_regen(interval, hud_image)
    pmb_statusfx.register_status("regeneration_"..tostring(interval), {
        ----
        fx_allow_player = true,
        fx_allow_object = true,
        -- if true, counts down one stack then the next, rather than all of them, allows stacking time up infinitely
        fx_only_tick_once = false,
        fx_only_apply_once = true,
        fx_timeout_individual = false,
        fx_use_player_functions_for_objects = true,
        ----
        on_apply_player = function(object, count, meta, params)
            meta.until_next_effect = interval
            return false -- true to prevent apply
        end,
        on_remove_player = function(object, count, meta, not_timeout)
            return false -- true to prevent remove
        end,
        on_step_player = function(object, count, meta, dtime)
            meta.until_next_effect = meta.until_next_effect - dtime
            if meta.until_next_effect <= 0 then
                meta.until_next_effect = meta.until_next_effect + interval
                object:set_hp(object:get_hp() + 1, "regeneration")
            end
            return false -- true to remove
        end,
        ----
        hud = (hud_image and pmb_statusfx.hud.make_effect(hud_image)) or nil
        ----
    })
end


reg_regen(1, "pmb_status_regeneration_1.png")
reg_regen(3, "pmb_status_regeneration_3.png")
reg_regen(8, "pmb_status_regeneration.png^[opacity:100")
reg_regen(20)

-- minetest.register_on_joinplayer(function(player, last_login)
--     minetest.after(3, function()
--         if not pmb_statusfx.player_has_status(player, "regeneration_20") then
--             pmb_statusfx.apply_status(player, "regeneration_20", 999, {})
--         end
--     end)
-- end)
