

pmb_trees.grow_tree = {}

pmb_trees.schematics = {}

function pmb_trees.register_sapling(name)
    local node_name = string.lower(name)
    pmb_trees.grow_tree[node_name] = pmb_trees.grow_tree[node_name] or function() return nil end

    minetest.register_node(("pmb_trees:" .. node_name .. "_sapling"), {
        description = name .. " sapling",
        drawtype = "plantlike",
        waving = 1,
        visual_scale = 1.0,
        tiles = {"pmb_sapling_" .. node_name .. ".png"},
        inventory_image = "pmb_sapling_" .. node_name .. ".png",
        wield_image = "pmb_sapling_" .. node_name .. ".png",
        paramtype = "light",
        sunlight_propagates = true,
        walkable = false,
        buildable_to = true,
        groups = { nature = 1, ["item_"..node_name.."_sapling"] = 1, dig_immediate = 3, sapling = 1,},
        -- drop = {"pmb_trees:" .. node_name .. "_sapling"},
        -- sounds = {},
        selection_box = {
            type = "fixed",
            fixed = {-5/16, -8/16, -5/16, 5/16, 1/16, 5/16},
        },
        is_ground_content = true,
        _tree_type = node_name,
        _tree_grow = function(pos, node)
            if type(pmb_trees.grow_tree[name]) == "function" then
                pmb_trees.grow_tree[name](pos, node)
            else
                pmb_trees.grow_tree.general(pos, node_name)
            end
        end,
        on_place = function(itemstack, placer, pointed_thing)
            return pmb_util.only_place_above(itemstack, placer, pointed_thing, {"soil"})
        end,
    })
end

pmb_trees.register_sapling("Oak")
pmb_trees.register_sapling("Ash")
pmb_trees.register_sapling("Spruce")


-- schematics and growing trees
local sch = pmb_sch.get_schematic_path

function pmb_trees.register_tree_schematic(kind, name)
    pmb_trees.schematics[kind] = pmb_trees.schematics[kind] or {}
    pmb_trees.schematics[kind][#pmb_trees.schematics[kind]+1] = sch(name)
end

-- OAK
pmb_trees.register_tree_schematic("oak", "tree_oak_0")
pmb_trees.register_tree_schematic("oak", "tree_oak_1")
pmb_trees.register_tree_schematic("oak", "tree_oak_2")
pmb_trees.register_tree_schematic("oak", "tree_oak_huge_0")
pmb_trees.register_tree_schematic("oak", "tree_oak_huge_1")
pmb_trees.register_tree_schematic("oak", "tree_oak_huge_2")

-- ASH
pmb_trees.register_tree_schematic("ash", "tree_ash_0")
pmb_trees.register_tree_schematic("ash", "tree_ash_1")
pmb_trees.register_tree_schematic("ash", "tree_ash_2")
pmb_trees.register_tree_schematic("ash", "tree_ash_3")
pmb_trees.register_tree_schematic("ash", "tree_ash_huge_0")

-- SPRUCE
pmb_trees.register_tree_schematic("spruce", "tree_spruce_1")
pmb_trees.register_tree_schematic("spruce", "tree_spruce_2")
pmb_trees.register_tree_schematic("spruce", "tree_spruce_3")
pmb_trees.register_tree_schematic("spruce", "tree_spruce_tall_0")
pmb_trees.register_tree_schematic("spruce", "tree_spruce_tall_1")
pmb_trees.register_tree_schematic("spruce", "tree_spruce_tall_2")
pmb_trees.register_tree_schematic("spruce", "tree_spruce_tall_3")
pmb_trees.register_tree_schematic("spruce", "tree_spruce_tall_4")


function pmb_trees.grow_tree.general(pos, name)
    minetest.set_node(pos, {name = "air"})

    if not pmb_trees.schematics[name] then
        minetest.log("error", "Warning, unable to place sapling type " .. tostring(name) .. " at " .. dump(pos))
        return end
    local variant = math.random(1, #pmb_trees.schematics[name])
    variant = pmb_trees.schematics[name][variant]
    minetest.place_schematic(pos, variant, "random", nil, false, {place_center_x=true, place_center_z=true})
end
