


if pmb_mob_spawn then
    pmb_mob_spawn.register_mob({
        name = "pmb_elementals:stone",
        groups = {"hostile", "pmb_stone_elemental"},
        biomes = {},
        on_spawn = function(self, pos) end,
        can_spawn = function(pos, spawn_info)
            if math.random() > 0.001 and math.random() > 0.001 then return false end
            if not pmb_dimensions.is_in("overworld", pos) then return false end
            if pmb_mob_spawn.has_head_room(pos, 3)
            and pmb_mob_spawn.has_light(pos, 12, 15) then
                if pmb_entity_api.has_mobs_in_radius(pos, 500, {"pmb_elementals:stone"}, 0, 0) then
                    return true
                end
            end
            return false
        end,
        can_despawn = function(self)
            local pos = self.object:get_pos()
            if not pos then return true end
            if not pmb_entity_api.has_mobs_in_radius(pos, 100, {"pmb_elementals:stone"}, 0, 2) then
                return true
            end
            if self._age and self._age < 300 then return false end
            return true
        end,
    })
    pmb_mob_spawn.cap.pmb_stone_elemental.max = 20

    pmb_mob_spawn.register_mob({
        name = "pmb_elementals:magma",
        groups = {"hostile", "pmb_magma_elemental"},
        biomes = {},
        on_spawn = function(self, pos) end,
        can_spawn = function(pos, spawn_info)
            -- if math.random() > 0.01 and math.random() > 0.01 then return false end
            local below_node = minetest.get_node(vector.offset(pos, 0, -1, 0))
            if pmb_mob_spawn.has_head_room(pos, 3)
            and (below_node.name == "pmb_underworld:lava_rock") then
                if pmb_entity_api.has_mobs_in_radius(pos, 100, {"pmb_elementals:magma"}, 0, 1) then
                    return true
                end
            end
            return false
        end,
        can_despawn = function(self)
            if math.random() > 0.01 and math.random() > 0.01 then return false end
            if not pmb_mob_spawn.has_player_in_range(self.object:get_pos(), 0, 100) then
                return true
            end
            if self._age and self._age < 20 then return false end
            local pos = self.object:get_pos()
            if not pos then
                return true
            end
            return true
        end,
    })
    pmb_mob_spawn.cap.pmb_magma_elemental.max = 20
end

