local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_tool("pmb_wings:canvas", {
    description = S("Canvas Wings"),
    _tt_color = "#f0f",
    _tt_long_desc = "[wip] These are not animated, but work.\n"..
    "Jump while falling to activate, or use [sprint] + [up] + [place] to slingshot.",
    inventory_image = "pmb_wings_canvas.png",

    _on_equipment_step = function(itemstack, player, dtime)
        return pmb_wings.on_equipment_step(itemstack, player, dtime)
    end,
    _on_equipped = function(itemstack, player, info)
        if info and info.is_from_joining then return end
        minetest.sound_play("pmb_lantern_take_out", {
            gain = 0.14,
            object = player,
        })
        return pmb_wings.on_equipped(itemstack, player)
    end,
    _on_unequipped = function(itemstack, player, info)
        return pmb_wings.on_unequipped(itemstack, player)
    end,

    _cooldown = 1,

    _wings_params = {
        max_speed = 50,
        gravity = 0.7,
        max_acceleration = 30,
        deceleration = 0.011,
        auto_pitch_up = 0.3,

        fall_bonus = 1.4, -- how much accel per pos.y fallen
        climb_penalty = 0.051, -- how much to slow down per pos.y climbed
        lift_factor = 2,
        lift_max = 0.9,
        lift_min = 0.6,
        start_mult_y = 0.1, -- for each vel.y
        start_mult_vel = 2.8, -- for each length(vel)
        low_speed_threshold = 40,
        low_speed_bonus = 1.0,

        pitch_acc = 0.0, -- how much accel per dir.y down
        pitch_acc_bonus = -0.03, -- how much accel per dir.y down
        pitch_up_penalty = 0.6,
        lift_resistance = 0.95, -- resists lift, but doesn't affect inertia
        yaw_deceleration = 0.25, -- per half rotation (pi)
        yaw_deceleration_threshold = 2, -- radians per sec, under this, yaw decel is x / 10

        slingshot_allow = true, -- allows sprint + rclick to slingshot the player
        -- slingshot_speed = 40, -- overrides speed after slingshot
        slingshot_velocity = 20, -- how much actuall vel to add when starting slingshot; how far up you fling
        slingshot_delay = 1, -- max amount of time before cancelling slingshot
        slingshot_vel_threshold = 99, -- vel.y < this --> start flying
        slingshot_direction = vector.new(0.8, 0.2, 0.8),

        hud = true,
        wind = true,
        fov = true,
        max_fov = 0.5,
    },
    _wings_on_fly = function(itemstack, player)
        minetest.sound_play("pmb_wings_open", {
            gain = 0.9,
            object = player,
            pitch = 0.9 + math.random() * 0.1,
        })
    end,
    _wings_on_land = function(itemstack, player)
    end,

    groups = { wings = 1, armor_chest = 1 },
})

if minetest.get_modpath("pmb_tcraft") then
    pmb_tcraft.register_craft({
        output = "pmb_wings:canvas",
        items = {
            ["pmb_items:plant_fibre"] = 20,
        }
    })
end


