local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


local drop_rarity = 8

local adjacent = {
    -- vector.new(0, 1, 0),
    -- vector.new(0,-1, 0),
    vector.new(0, 0, 1),
    vector.new(0, 0,-1),
    vector.new(1, 0, 0),
    vector.new(-1,0, 0),
}
local function get_adjacent_count(pos, group)
    local count = 0
    for i, p in pairs(adjacent) do
        local node = minetest.get_node(vector.add(pos, p))
        if minetest.get_item_group(node.name, group) > 0 then
            count = count + 1
        end
    end
    return count
end


-- todo: add damage to falling nodes
local function on_timer(pos, elapsed)
    local below = vector.offset(pos, 0, -1, 0)
    if (minetest.registered_nodes[minetest.get_node(below).name] or {}).buildable_to then
        local bool, falling_ent = minetest.spawn_falling_node(pos)
        return false
    end
end

local time_max = 600
local prop_all = true
local function on_update(pos, cause, user, count, payload)

    local timer = minetest.get_node_timer(pos)
    if timer:is_started() then return false end

    if cause == "cavein" then
        local node = minetest.get_node(vector.offset(pos, 0, -1, 0))
        local def = minetest.registered_nodes[node.name]
        if def and (def.buildable_to
        or (prop_all and (minetest.get_item_group(node.name, "loose_stone") > 0))) then
            local offset = pos.y - (payload and (payload.pos or {}).y) or pos.y
            timer:start(1)
            timer:set((payload and payload.time or 1) + offset * 0.12, math.random() * 0.1)
            return payload
        end
    elseif (cause == "dig" or cause == "place") then
        -- don't start a cave-in check unless there is air below
        local below = vector.offset(pos, 0, -1, 0)
        local supported = (minetest.registered_nodes[minetest.get_node(below).name] or {}).buildable_to
        if count <= 10 and not supported then
            return false
        end

        local time = math.random(time_max)

        local spread = math.random(3, 12)
        if supported and math.random() < 0.1 then
            pmb_node_update.update_node_propagate(pos, "cavein", nil, spread, 0.1, {pos=pos, time=time}, pos)
            return payload
        end

        if (not supported) then return payload end

        local adjcountbelow = get_adjacent_count(vector.offset(pos, 0, -1, 0), "full_solid")
        local adjcount = get_adjacent_count(vector.offset(pos, 0, 0, 0), "full_solid")
        if (adjcountbelow == 0) or (adjcount <= 1) then
            pmb_node_update.update_node_propagate(pos, "cavein", nil, spread + 1, 0.1, {pos=pos, time=time / 2})
            return false
        end

        return payload
    end
end

minetest.register_node("pmb_stone:loose_stone", {
    description = pmb_util.desc(S("Loose Stone"), "grey"),
    _tt_long_desc = S("Not to be confused with Tight Stone"),
    groups = { full_solid = 1, nature = 1, loose_stone = 1, item_loose_stone = 1, oddly_breakable_by_hand = 1, solid = 1,
            suffocates = 2, cracky = 1, stone = 1, silk_touchable = 1, natural_stone = 1 },
    tiles = { "pmb_loose_stone.png" },
    drop = {
        max_items = 4,
        items = {
            {
                items = {"pmb_stone:cobble 1"},
            },
        },
    },
    sounds = pmb_sounds.default_rocky(),
    on_timer = on_timer,
    _on_node_update = on_update,
})

pmb_stone.register_ores_for_node("pmb_stone:loose_stone")
