local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local uses

uses = 256
minetest.register_tool("pmb_hammer:iron_hammer", {
    description = pmb_util.desc(S("Iron Hammer"), "grey"),
    inventory_image = "pmb_hammer_iron_hammer.png",
    _tt_long_desc = S("Replaces nodes quickly without having to dig and fill nodes back in."),
    _tt_how_to_use = S("Paint: [place node]").."\n"..S("Pick: [dig]"),
    _tt_uses = uses,
    _uses = uses,
    tool_capabilities = {
        full_punch_interval = 2,
        groupcaps = {
            cracky = {
                maxlevel = 3,
                uses = uses,
            },
            crumbly = {
                maxlevel = 3,
                uses = uses,
            },
            choppy = {
                maxlevel = 3,
                uses = uses,
            },
            snappy = {
                maxlevel = 3,
                uses = uses,
            },
        },
        damage_groups = {
            blunt=5,
        },
    },
    groups = { hammer = 2 },
    on_use = pmb_hammer.get_paint_node_from_pointed,
    on_place = pmb_hammer.paint_node,
})
if true then
    local m = "pmb_items:stick"
    local b = "pmb_items:iron_bar"
    minetest.register_craft({
        output = "pmb_hammer:iron_hammer",
        recipe = {
        {b, m, b},
        {"",m,""},
        {"",m,""},
        },
    })
end
