
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = 'ruined_valley'

pmb_biomes.register_biome({
    name = this_biome,

    node_top = 'pmb_soil:dirt_with_grass',
    depth_top = 1,

    node_filler = 'pmb_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'pmb_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 20,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 2,

    heat_point = 72,
    humidity_point = 45,
}, {"light_scrub", "ash", "ruin", "overworld", "shore"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = pmb_sch.get_schematic_path


-- ORES

local size = 100
-- GRASS VAR 4
minetest.register_ore({
        ore_type	= "stratum",
        ore		    = "pmb_soil:grass_variant_4",
        wherein		= {"group:topsoil"},
        y_min = sealevel-20,
        y_max = sealevel+200,
        clust_scarcity    = 1,
        noise_params        = {
                offset = sealevel+10,
                scale = 200,
                spread = {x = size, y = size, z = size},
                seed = 354387,
                octaves = 4,
                lacunarity = 3,
        },
        np_stratum_thickness = {
                offset = 20,
                scale = 240,
                spread = {x = 100, y = 100, z = 100},
                seed = 89567864,
                octaves = 4,
                lacunarity = 3,
                persistence = 0.2
        },
        stratum_thickness = 20,
        biomes = {this_biome},
})

size = 30
minetest.register_ore({
        ore_type	= "stratum",
        ore		    = "pmb_soil:forest_grass_1",
        wherein		= {"group:topsoil"},
        y_min = sealevel-20,
        y_max = sealevel+200,
        clust_scarcity    = 1,
        noise_params        = {
                offset = sealevel+10,
                scale = 200,
                spread = {x = size, y = size, z = size},
                seed = 5643,
                octaves = 2,
        },
        np_stratum_thickness = {
                offset = 50,
                scale = 240,
                spread = {x = 20, y = 20, z = 20},
                seed = 900786,
                octaves = 4,
                persistence = 0.2
        },
        stratum_thickness = 20,
        biomes = {this_biome},
})
minetest.register_ore({
        ore_type	= "stratum",
        ore		    = "pmb_soil:forest_grass_2",
        wherein		= {"pmb_soil:forest_grass_1"},
        y_min = sealevel-20,
        y_max = sealevel+200,
        clust_scarcity    = 1,
        noise_params        = {
                offset = sealevel+10,
                scale = 200,
                spread = {x = size, y = size, z = size},
                seed = 5643,
                octaves = 2,
        },
        np_stratum_thickness = {
                offset = 0,
                scale = 190,
                spread = {x = 20, y = 20, z = 20},
                seed = 900786,
                octaves = 5,
                persistence = 0.2
        },
        stratum_thickness = 20,
        biomes = {this_biome},
})



pmb_biomes.add_ruins({this_biome}, 0.5)



-- trees
if true then
-- oak

-- lots of bunched up trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"pmb_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
            offset = 0.01,
            scale = 0.0035,
            spread = {x = 50, y = 50, z = 50},
            seed = 354,
            octaves = 3,
            persistence = 0.7,
            lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_tall_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"pmb_soil:forest_grass_2"},
    sidelen = 80,
    noise_params = {
            offset = 0.01,
            scale = 0.0035,
            spread = {x = 50, y = 50, z = 50},
            seed = 234,
            octaves = 3,
            persistence = 0.7,
            lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_spruce_tall_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})


-- boulders
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"pmb_soil:dirt_with_grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("boulder_small_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"pmb_soil:dirt_with_grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("boulder_small_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"pmb_soil:dirt_with_grass"},
    sidelen = 80,
    fill_ratio = 0.0005,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("boulder_small_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
end


local function do_grasses(num, seed)
    minetest.register_decoration({
            deco_type = "simple",
            place_on = {"pmb_soil:dirt_with_grass"},
            noise_params = {
                    offset = -0.11,
                    scale = 0.19,
                    spread = {x = 20, y = 20, z = 20},
                    seed = seed,
                    octaves = 1,
                    persist = 1.2
            },
            biomes = {this_biome},
            y_max = alt_max,
            y_min = sealevel,
            decoration = num,
    })
end

do_grasses("pmb_flora:fern_0", 6546)
do_grasses("pmb_flora:fern_1", 6546)
do_grasses("pmb_flora:fern_0", 6546)
do_grasses("pmb_flora:fern_1", 6546)


do_grasses("pmb_flora:grass_0", 43)
do_grasses("pmb_flora:grass_0", 43)
do_grasses("pmb_flora:grass_1", 43)
do_grasses("pmb_flora:grass_1", 43)


minetest.register_decoration({
    deco_type = "simple",
    place_on = {"pmb_soil:dirt_with_grass"},
    noise_params = {
            offset = -0.49,
            scale = 0.53,
            spread = {x = 2, y = 2, z = 2},
            seed = 9087,
            octaves = 1,
            persist = 1.2
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    decoration = "pmb_flora:potato_2",
})
minetest.register_decoration({
        deco_type = "simple",
        place_on = {"pmb_soil:dirt_with_grass"},
        noise_params = {
                offset = -0.49,
                scale = 0.53,
                spread = {x = 2, y = 2, z = 2},
                seed = 9087,
                octaves = 1,
                persist = 1.2
        },
        biomes = {this_biome},
        y_max = alt_max,
        y_min = sealevel,
        decoration = "pmb_flora:potato_3",
})


