
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

    local this_biome = 'grasslands_valley'

pmb_biomes.register_biome({
    name = this_biome,

    node_top = 'pmb_soil:grass_variant_4',
    depth_top = 1,

    node_filler = 'pmb_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'pmb_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 20,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 1,

    heat_point = 52,
    humidity_point = 40,
}, {"field", "overworld", "clearing", "flowers"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = pmb_sch.get_schematic_path

-- minetest.place_schematic(pos, schematic_path, "random", nil, false)

-- huge oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- huge oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_1"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- huge oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- sparse trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0001,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

-- sparse trees
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.001,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
-- bushes in large sparse clumps
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 80,
    fill_ratio = 0.0002,
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})

local size = 10
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "pmb_soil:grass_variant_1",
    wherein        = {"pmb_soil:dirt_with_grass"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = sealevel,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 5937,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = -10,
        scale = 100,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome,"grasslands"},
})

minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "pmb_soil:grass_variant_2",
    wherein		= {"pmb_soil:grass_variant_1"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = sealevel,
        scale = 200,
        spread = {x = size, y = size, z = size},
        seed = 543,
        octaves = 2,
    },
    np_stratum_thickness = {
        offset = -10,
        scale = 100,
        spread = {x = 20, y = 20, z = 20},
        seed = 900786,
        octaves = 4,
        persistence = 0.2
    },
    stratum_thickness = 20,
    biomes = {this_biome,"grasslands"},
})

minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "pmb_soil:grass_variant_3",
    wherein		= {"pmb_soil:grass_variant_1"},
    clust_scarcity	= 100,
    clust_num_ores	= 2,
    clust_size	= 4,
    y_max = alt_max,
    y_min = alt_min,
    biomes = {this_biome,"grasslands"},
})
