local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)





minetest.register_node('pmb_glass:glass', {
    description = pmb_util.desc(S("Glass"), "grey"),
    _tt_long_desc = S("Normal glass, inconspicuously made of sand"),
    groups = { full_solid = 1, item_glass = 1, oddly_breakable_by_hand = 1, solid = 1, suffocates = 2, glass = 1,  silk_touchable = 1 },
    drawtype = "glasslike",
    sunlight_propagates = true,
    paramtype = "light",
    tiles = { {name = "pmb_glass_frame.png",}},
    backface_culling = false,
    use_texture_alpha = "clip",
    sounds = pmb_sounds.default_stone(),
})
if pmb_cooking then
    pmb_cooking.register_cooking({
        raw = "pmb_soil:sand",
        cooked = "pmb_glass:glass",
        input_count = 1,
        output_count = 1,
        cook_time = 2,
        groups = {"cooker_crucible"},
    })
end
