local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

minetest.register_tool("pmb_bow:bow", {
    description = S("Bow"),
    wield_image = "pmb_bow.png",
    inventory_image = "pmb_bow_bar.png",
    groups = { weapon = 1 },
    range = 0,
    on_secondary_use = function(itemstack, user, pointed_thing)
        return pmb_combat.cooldown.attempt_to_use(itemstack, user, pointed_thing)
    end,
    on_place = function(itemstack, user, pointed_thing)
        return pmb_combat.cooldown.attempt_to_use(itemstack, user, pointed_thing)
    end,
    _on_windup_start = function(itemstack, player)
        player_model.set_anim(player, {tag="pmb_bow_bow_aim", actions={"aim"}})
        minetest.sound_play(("pmb_bow_draw"), {
            gain = 0.5,
            object = player,
            max_hear_distance = 100,
            pitch = (math.random()*0.1) + 0.90
        })
    end,
    -- _on_windup_cancelled = function(itemstack, player)
    --     return itemstack
    -- end,
    _on_windup_complete = function(itemstack, player)
        minetest.sound_play(("pmb_bow_draw_complete"), {
            gain = 0.9,
            object = player,
            max_hear_distance = 50,
        })
        return itemstack
    end,

    wield_scale = vector.new(2, 2, 2),

    on_select = function(itemstack, player)
    end,
    on_deselect = function(itemstack, player)
        player_model.unset_anim(player, "pmb_bow_bow_aim")
        return pmb_combat.cooldown.on_wield_change_from(itemstack, player)
    end,
    on_step = function(itemstack, player, dtime)
        local just_thrown = false
        itemstack, just_thrown = pmb_combat.throwable.on_wield_throwable(player, "pmb_bow:arrow_ENTITY", itemstack, {
            allow_partial_throw = true,
            min_windup = 0.5,
        })
        if just_thrown then
            wield3d.update(player, {
                _wield3d_textures = "blank.png",
            })
            player_model.unset_anim(player, "pmb_bow_bow_aim")
            minetest.sound_play(("pmb_bow_shoot"), {
                gain = 0.9,
                object = player,
                max_hear_distance = 50,
                pitch = (math.random()*0.1) + 0.90
            })
        end
        return itemstack
    end,
    _cooldown = 0,
    _windup = 1.2,
    _prj_speed = 45,
    _prj_inaccuracy = 0.005,
})

pmb_tcraft.register_craft({
    output = "pmb_bow:bow",
    items = {
        ["pmb_items:stick"] = 4,
        ["pmb_items:plant_fibre"] = 10,
    }
})
