local sealevel = pmb_underworld.sea_level
local alt_max = pmb_underworld.alt_max
local alt_min = pmb_underworld.alt_min
local sch = pmb_underworld.get_schematic_path


local this_biome = "underworld_arlior_growth"


minetest.register_decoration({
    deco_type = "simple",
    place_on = {"pmb_underworld:arlior"},
    height = 1,
    height_max = 10,
    noise_params = {
        offset = -0.01,
        scale = 0.03,
        spread = {x = 30, y = 30, z = 30},
        seed = 9067,
        octaves = 3,
        persist = 0.1
    },
    biomes = { this_biome },
    y_max = alt_max,
    y_min = sealevel,
    decoration = "pmb_underworld:arlior_growth",
    flags = "all_ceilings, all_floors",
})
minetest.register_decoration({
    deco_type = "simple",
    place_on = {"pmb_underworld:arlior"},
    height = 1,
    height_max = 10,
    noise_params = {
        offset = -0.01,
        scale = 0.03,
        spread = {x = 30, y = 30, z = 30},
        seed = 9067,
        octaves = 3,
        persist = 0.1
    },
    biomes = { this_biome },
    y_max = alt_max,
    y_min = sealevel,
    decoration = "pmb_underworld:arlior_growth_purple",
    flags = "all_floors, all_ceilings",
})





-- holes in surface
minetest.register_ore({
    ore_type       = "stratum",
    ore            = "pmb_underworld:arlior",
    wherein        = {"pmb_underworld:worknode_topsoil"},
    y_min = alt_min,
    y_max = alt_max,
    clust_scarcity  = 1,
    noise_params    = {
        offset = alt_min + alt_max / 2,
        scale = math.abs(alt_max - alt_min)/ 2,
        spread = {x = 50, y = 50, z = 50},
        seed = 54376,
        octaves = 5,
    },
    np_stratum_thickness = {
        offset = -2000,
        scale = 7000,
        spread = {x = 10, y = 10, z = 10},
        seed = 4388,
        octaves = 3,
        persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = { this_biome },
})



minetest.register_ore({
    ore_type = "stratum",
    ore      = "pmb_underworld:arlioran",
    wherein  = {"pmb_underworld:worknode_topsoil"},
    y_min = pmb_underworld.alt_min,
    y_max = pmb_underworld.alt_max,
    biomes = { this_biome }
})

minetest.register_ore({
    ore_type = "stratum",
    ore      = "pmb_underworld:arlior",
    wherein  = {"pmb_underworld:worknode_soil", "pmb_underworld:lava_rock", "pmb_underworld:worknode_ceiling",},
    y_min = pmb_underworld.alt_min,
    y_max = pmb_underworld.alt_max,
    biomes = { this_biome }
})
