local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)





minetest.register_node('pmb_underworld:lava_rock_mythril', {
    description = pmb_util.desc(S("Mythril Ore"), "blue"),
    groups = { full_solid = 1, nature = 1, item_lava_rock_mythril = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 4, solid = 1, suffocates = 2 },
    tiles = {"pmb_obsidian.png^pmb_underworld_mythril_ore.png"},
    sounds = pmb_sounds.default_stone(),
    -- light_source = pmb_underworld.lava_rock_light,
    drop = {
        max_items = 1,
        items = {
            {
                items = {'pmb_underworld:mythril'},
            },
        },
    },
})
minetest.register_craftitem("pmb_underworld:mythril", {
    description = pmb_util.desc(S("Mythril Ore"), "blue"),
    inventory_image = "pmb_underworld_mythril.png",
    groups = { item_mythril = 1, craftitem = 1, mythril = 1, nugget = 1, mythril_nugget = 1, },
})


minetest.register_node('pmb_underworld:lava_rock_cortite', {
    description = pmb_util.desc(S("Cortite Ore"), "green"),
    groups = { full_solid = 1, nature = 1, item_lava_rock_cortite = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_lava_rock.png^pmb_underworld_cortite_ore.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light,
    drop = {
        max_items = 1,
        items = {
            {
                items = {'pmb_underworld:cortite'},
            },
        },
    },
})
minetest.register_craftitem("pmb_underworld:cortite", {
    description = pmb_util.desc(S("Cortite"), "green"),
    inventory_image = "pmb_underworld_cortite.png",
    groups = { item_cortite = 1, craftitem = 1, cortite = 1, nugget = 1, cortite_nugget = 1, },
})
