local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local sfx = pmb_statusfx.registered_status_effects
local epl = pmb_statusfx.player_effects

pmb_statusfx.hud = {}
pmb_statusfx.hud.pl = {}
local pl = pmb_statusfx.hud.pl


local scale_multiplier = 0.75

function pmb_statusfx.hud.make_effect(image)
    return {
        hud_elem_type = "image",
        scale = {x=4*scale_multiplier, y=4*scale_multiplier},
        text = image,
        position = {x=0, y=0.95},
        offset = {x=-100, y=0},
        z_index = 20
    }
end

function pmb_statusfx.hud.add_hud(player, status_name)
    if not pl[player] then pl[player] = {stack={}} end

    if sfx[status_name] and sfx[status_name].hud
    and not pl[player].stack[status_name] then
        local def = table.copy(sfx[status_name].hud)
        def = def.text .. "^[opacity:200"

        local hud_id = player:hud_add(sfx[status_name].hud)
        pl[player].stack[status_name] = hud_id
        pl[player]._changes_made = true
    end
end
function pmb_statusfx.hud.remove_hud(player, status_name)
    if not pl[player] then pl[player] = {stack={}} end
    if not pl[player].stack[status_name] then return end

    player:hud_remove(pl[player].stack[status_name])
    pl[player].stack[status_name] = nil
    pl[player]._changes_made = true
end

function pmb_statusfx.hud.update_hud(player)
    if not pl[player] then pl[player] = {stack={}} end
    if pl[player]._changes_made then
        pl[player]._changes_made = false
        local offsetx = 40
        local offsety = 0
        local spacing = 16 * 4 * scale_multiplier + 4
        for status_name, hud_id in pairs(pl[player].stack) do
            player:hud_change(hud_id, "offset", {
                x = offsetx,
                y = offsety,
            })
            offsety = offsety - spacing
        end
    else
        local i = 0
        for status_name, hud_id in pairs(pl[player].stack) do
            local time_left = epl[player][status_name].meta.time
            local blink = epl[player][status_name].blink
            local was_blinking = epl[player][status_name].was_blinking or false

            local switch = (math.ceil(time_left * 3) % 2 == 0)

            if time_left < 5 and not blink and switch then
                epl[player][status_name].blink = true
                local image = sfx[status_name].hud and sfx[status_name].hud.text
                image = image .. "^[opacity:100"
                player:hud_change(hud_id, "text", image)

                epl[player][status_name].was_blinking = true
            elseif time_left < 5 and blink and not switch then
                epl[player][status_name].blink = false
                local image = sfx[status_name].hud and sfx[status_name].hud.text
                image = image .. "^[opacity:250"
                player:hud_change(hud_id, "text", image)

                epl[player][status_name].was_blinking = true
            elseif time_left > 5 and was_blinking then
                epl[player][status_name].blink = true
                local image = sfx[status_name].hud and sfx[status_name].hud.text
                image = image .. "^[opacity:200"
                player:hud_change(hud_id, "text", image)

                epl[player][status_name].was_blinking = false
            end
            i = i + 1
        end
    end
end


function pmb_statusfx.hud.remove_all_huds(player)
    for status_name, status_data in pairs(epl[player]) do
        local stack = status_data.stack
        if stack and #stack > 0 then
            pmb_statusfx.hud.remove_hud(player, status_name)
        end
    end
end


function pmb_statusfx.hud.refresh_hud(player)
    if not epl[player] then return end
    for status_name, status_data in pairs(epl[player]) do
        local stack = status_data.stack
        if stack and #stack > 0 then
            pmb_statusfx.hud.add_hud(player, status_name)
        end
    end
end


minetest.register_on_joinplayer(function(player, last_login)
    minetest.after(0.2, function()
        pmb_statusfx.hud.refresh_hud(player)
    end)
end)



