
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

function pmb_map_base.register_ores_for_node(in_node, flags)
    flags = flags or {skip={}}
    local ore_mult = flags.ore_mult or pmb_vars.overworld.ore_multiplier

    -- coal
    if not flags.skip.coal then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_coal_ore",
        wherein        = {in_node},
        clust_scarcity = 309050 / ore_mult,
        clust_num_ores = 100,
        clust_size     = 8,
        y_min = alt_min,
        y_max = sealevel - 60,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_coal_ore", --"pmb_lights:torch", -- use this for testing
        wherein        = {in_node},
        clust_scarcity = 109050 / ore_mult,
        clust_num_ores = 20,
        clust_size     = 9,
        y_min = alt_min,
        y_max = sealevel,
    })
    -- more coal in the mid range to help new players
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_coal_ore",
        wherein        = {in_node},
        clust_scarcity = 650 / ore_mult,
        clust_num_ores = 3,
        clust_size     = 3,
        y_min = sealevel - 10,
        y_max = sealevel + 100,
    })
    end

    -- IRON
    if not flags.skip.tin then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_iron_ore",
        wherein        = {in_node},
        clust_scarcity = 1000 / ore_mult,
        clust_num_ores = 2,
        clust_size     = 2,
        y_min = sealevel,
        y_max = alt_max,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_iron_ore",
        wherein        = {in_node},
        clust_scarcity = 1600 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 2,
        y_min = sealevel + 50,
        y_max = alt_max,
    })
    -- lower is more ores?
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_iron_ore",
        wherein        = {in_node},
        clust_scarcity = 1000 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 3,
        y_min = alt_min,
        y_max = sealevel,
    })
    end



    -- TIN
    if not flags.skip.tin then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_tin_ore",
        wherein        = {in_node},
        clust_scarcity = 6650 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel + 10,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_tin_ore",
        wherein        = {in_node},
        clust_scarcity = 3650 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 3,
        y_min = alt_min,
        y_max = alt_max,
    })
    end


    -- COPPER
    if not flags.skip.copper then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_copper_ore",
        wherein        = {in_node},
        clust_scarcity = 2650 / ore_mult,
        clust_num_ores = 8,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel + 20,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_copper_ore",
        wherein        = {in_node},
        clust_scarcity = 3650 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 3,
        y_min = alt_min,
        y_max = alt_max,
    })
    end


    -- LAPIS
    if not flags.skip.lapis then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_lapis_ore",
        wherein        = {in_node},
        clust_scarcity = 6000 / ore_mult,
        clust_num_ores = 5,
        clust_size     = 4,
        y_min = sealevel - 100,
        y_max = sealevel - 50,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_lapis_ore",
        wherein        = {in_node},
        clust_scarcity = 3500 / ore_mult,
        clust_num_ores = 2,
        clust_size     = 4,
        y_min = sealevel + math.abs(alt_max - sealevel) * 0.6,
        y_max = alt_max,
    })
    end



    -- DIAMOND
    if not flags.skip.diamond then
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_diamond_ore",
        wherein        = {in_node},
        clust_scarcity = 2650 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 4,
        y_min = alt_min,
        y_max = sealevel - 50,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_diamond_ore",
        wherein        = {in_node},
        clust_scarcity = 200000 / ore_mult,
        clust_num_ores = 1,
        clust_size     = 1,
        y_min = alt_min,
        y_max = alt_max,
    })
    minetest.register_ore({
        ore_type       = "scatter",
        ore            = (flags.node_prefix or in_node).."_diamond_ore",
        wherein        = {in_node},
        clust_scarcity = 3650 / ore_mult,
        clust_num_ores = 4,
        clust_size     = 3,
        y_min = sealevel + math.abs(alt_max - sealevel) * 0.6,
        y_max = alt_max,
    })
    end
end

pmb_map_base.register_ores_for_node("pmb_stone:stone")
pmb_map_base.register_ores_for_node("pmb_stone:sandstone")
pmb_map_base.register_ores_for_node("pmb_stone:limestone")
pmb_map_base.register_ores_for_node("pmb_stone:granite")
pmb_map_base.register_ores_for_node("pmb_stone:loose_stone")

pmb_map_base.register_ores_for_node("pmb_soil:sand", {
    skip = {diamond=1, lapis=1, coal=1},
    ore_mult = 0.1,
})
pmb_map_base.register_ores_for_node("pmb_soil:dirt", {
    skip = {coal=1},
    ore_mult = 0.7,
})
