local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local torch = {
    width = 2 / 16,
    height = 10 / 16,
}

pmb_lights = {}

function pmb_lights.on_place_torch(pos, placer, itemstack, pointed_thing)
    pmb_util.rotate_and_place_against(pos, placer, itemstack, pointed_thing, {offset = 0, copy_same_node = true, vflip = false, no_yaw = true})
end


minetest.register_node("pmb_lights:torch", {
    description = pmb_util.desc(S("Torch"), "grey"),
    light_source = 14,
    drawtype = "nodebox",
    use_texture_alpha = "opaque",
    walkable = false,
    paramtype2 = "facedir",
    tiles = {"pmb_lights_torch_top.png", "pmb_lights_torch.png",},
    node_box = {
        type = "fixed",
        fixed = {
            -torch.width/2, -0.5, -torch.width/2,
            torch.width/2, -0.5 + torch.height, torch.width/2,},
    },
    groups = { dig_immediate = 3, deco_block = 1, },
    sounds = pmb_sounds.default_stone(),
    -- after_place_node = pmb_lights.on_place_torch,
    _on_node_update = function(pos, cause, user, count, payload)
        if pmb_util.has_adjacent(pos, "full_solid") == 0 then
            minetest.dig_node(pos)
        else
            pmb_util.rotate_to_group(pos, "full_solid")
        end
    end
})

pmb_tcraft.register_group_craft({
    output = "pmb_lights:torch 4",
    items = {
        ["pmb_items:stick"] = 4
    },
    group = "coal",
    group_count = 1
})
