local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local reg = {}

function pmb_ambiance.register_ambience(name, def)
    reg[#reg+1] = def
end



-- this API is not implemented yet



local pl = {}

local function check_player(player)
    if not pl[player] then
        pl[player] = {
            stack = {},
            time = 1,
        }
    end
end

function pmb_ambiance.play(player, spec, fade)
    pl[player].id = minetest.sound_play(spec.name, spec)
end


local cricket_biomes = pmb_biomes.overworld or {}

pmb_ambiance.register_ambience("pmb_crickets", {
    -- only one of these can play at a time, and each has its own random selection
    -- leave nil to use name given above
    tag = nil,
    duration = 5,
    -- function returns a soundspec
    soundspec = function(name) return {
        sound = "crickets joanaseabra CC0 freesound",
        gain = 0.4,
        pitch = math.random() * 0.1 + 0.95,
        name = name
    } end,
    -- return false to not play, true to play
    can_play = function(self, player, data)
        local t = minetest.get_timeofday()
        if not (t < 0.25 and t > 0.75) then return end
        local pi = player_info.get(player)
        local dist = pi and pi.radar_avg
        if (data.biome_name and cricket_biomes[data.biome_name]) then
            return true
        end
        return true
    end,
    -- runs each second
    on_update = function(self, player)
        local pi = player_info.get(player)
        if pi and pi.radar_avg then
            local factor = 1 - math.min(math.max(pi.radar_avg / 20, 0), 1)
            local pitch = 1 - factor * 0.1
            local spec = self.soundspec(player:get_player_name())
        end
    end,
})

minetest.register_globalstep(function(dtime)
    if true then return end -- disable for now
    for i, player in ipairs(minetest.get_connected_players()) do
    repeat
        check_player(player)
        if pl[player].time > 0 then pl[player].time = pl[player].time - dtime break end
        pl[player].time = 1

        local pos = player:get_pos()
        if not pos then break end
        local biome_data = minetest.get_biome_data(pos)
        local data = {
            biome_name = minetest.get_biome_name(biome_data.biome) or "default"
        }
        for k, def in ipairs(reg) do
            --
        end
    until true
    end
end)

