

local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)


pmb_underworld = {}


pmb_underworld.alt_min = pmb_vars.overworld.alt_min - 1000
pmb_underworld.alt_max = pmb_vars.overworld.alt_min
pmb_underworld.sea_level = pmb_underworld.alt_min + 70
pmb_underworld.ore_multiplier = 1

pmb_underworld.soil = 5
pmb_underworld.topsoil = 2
pmb_underworld.dust = 1
pmb_underworld.ceiling = 3

pmb_underworld.lava_rock_light = 5

-- register underworld
pmb_dimensions.register_dimension({
    name = "underworld",
    is_full_strata = true,
    min_y = pmb_underworld.alt_min,
    max_y = pmb_underworld.alt_max,
    sea_level = pmb_underworld.sea_level,
    ore_multiplier = 1,
})

-- utilities
dofile(mod_path .. DIR_DELIM .. "utilities.lua")


-- nodes
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "worknodes.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "glow_rock.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "lava_coral.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "lava_rock.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "lava_brick.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "soils.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "ores.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "mythrite.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "fog.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "arlior.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "arlior_plants.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "arlior_brick.lua")
dofile(mod_path .. DIR_DELIM .. "nodes" .. DIR_DELIM .. "arlior_growth.lua")

-- items
dofile(mod_path .. DIR_DELIM .. "items" .. DIR_DELIM .. "craftitems.lua")
dofile(mod_path .. DIR_DELIM .. "items" .. DIR_DELIM .. "tools.lua")
dofile(mod_path .. DIR_DELIM .. "items" .. DIR_DELIM .. "cortite_sceptre.lua")
if pmb_hammer ~= nil then dofile(mod_path .. DIR_DELIM .. "items" .. DIR_DELIM .. "hammer.lua") end

-- mobs
dofile(mod_path .. DIR_DELIM .. "mobs" .. DIR_DELIM .. "coral_bug.lua")

-- mapgen
dofile(mod_path .. DIR_DELIM .. "mapgen" .. DIR_DELIM .. "biomes.lua")
dofile(mod_path .. DIR_DELIM .. "mapgen" .. DIR_DELIM .. "scripts" .. DIR_DELIM .. "caverns.lua")
dofile(mod_path .. DIR_DELIM .. "mapgen" .. DIR_DELIM .. "scripts" .. DIR_DELIM .. "columns.lua")
dofile(mod_path .. DIR_DELIM .. "mapgen" .. DIR_DELIM .. "scripts" .. DIR_DELIM .. "overworld_blend.lua")
dofile(mod_path .. DIR_DELIM .. "mapgen" .. DIR_DELIM .. "scripts" .. DIR_DELIM .. "base_terrain.lua")
dofile(mod_path .. DIR_DELIM .. "mapgen" .. DIR_DELIM .. "soils.lua")

-- do this after everything else in mapgen so you know which nodes are topsoil and which are ceiling
dofile(mod_path .. DIR_DELIM .. "mapgen" .. DIR_DELIM .. "scripts" .. DIR_DELIM .. "cleaner.lua")

-- do decorations and ores last
dofile(mod_path .. DIR_DELIM .. "mapgen" .. DIR_DELIM .. "decorations.lua")
dofile(mod_path .. DIR_DELIM .. "mapgen" .. DIR_DELIM .. "ore.lua")

local set_light = function(minp, maxp, seed)
    if (maxp.y < pmb_underworld.alt_min) or (minp.y > pmb_underworld.alt_max) then return end
    local vm = minetest.get_voxel_manip(minp, maxp)
    vm:update_liquids()
    vm:write_to_map()
    vm:update_map()
end
minetest.register_on_generated(set_light)
