local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local default_craft_count = 8

pmb_dyes.dye_list = {}

local function register_dye(color_name, from_items, colorstring, flags)
    if not flags then flags = {} end
    local low = string.lower(color_name)
    low = string.gsub(low, " ", "_")
    local name = "pmb_dyes:" .. low

    pmb_dyes.dye_list[#pmb_dyes.dye_list+1] = {
        dye_item_name = name,
        color_name = color_name,
        name = low,
        color = colorstring,
        colorize_amount = flags.colorize_amount
    }

    minetest.register_craftitem(name, {
        description = S(color_name .. " Dye"),
        inventory_image = "pmb_dyes_base.png"..
        "^[multiply:"..colorstring.."^[colorize:"..colorstring..":"..(flags.colorize_amount or 0),
        groups = { craftitem = 1, dye = 1, ["dye_" .. low] = 1 },
    })

    if flags.no_craft then return end
    pmb_tcraft.register_craft({
        output = name.." "..(flags.craft_count or default_craft_count),
        items = from_items
    })
end

register_dye("Blue", {["pmb_items:lapis_lazuli"]=1}, "#4155e6", {colorize_amount = 100})
register_dye("Light Blue", {["pmb_dyes:blue"]=1, ["pmb_dyes:white"]=1}, "#85a9ff", {colorize_amount = 100, craft_count = 2})

register_dye("Green", {["pmb_dyes:yellow"]=1, ["pmb_dyes:blue"]=1}, "#57a856", {colorize_amount = 50})
register_dye("Dark Green", {["pmb_dyes:green"]=1, ["pmb_dyes:black"]=1}, "#3c784d", {colorize_amount = 50, craft_count = 2})

register_dye("Yellow", {["pmb_flora:flower_yellow"]=1}, "#fff959", {colorize_amount = 150})
register_dye("Orange", {["pmb_dyes:yellow"]=1, ["pmb_dyes:red"]=1}, "#ff883c", {colorize_amount = 150, craft_count = 2})
register_dye("Brown", {["pmb_dyes:orange"]=1, ["pmb_dyes:black"]=1}, "#9a6d59", {colorize_amount = 150, craft_count = 2})

register_dye("Red", {["pmb_flora:flower_red"]=1}, "#f84639", {colorize_amount = 100})
register_dye("Dark Red", {["pmb_dyes:red"]=1, ["pmb_dyes:black"]=1}, "#a53349", {colorize_amount = 100})
register_dye("Pink", {["pmb_dyes:red"]=1, ["pmb_dyes:white"]=1}, "#ffbcf9", {colorize_amount = 150})

register_dye("Purple", {["pmb_dyes:red"]=1, ["pmb_dyes:blue"]=1}, "#9d49cc", {colorize_amount = 100, craft_count = 2})

register_dye("Black", {["pmb_items:charcoal"]=1}, "#333333", {colorize_amount = 100})

register_dye("Grey", {["pmb_items:charcoal"]=1}, "#7b7b7b", {colorize_amount = 100})
register_dye("Light Grey", {["pmb_items:charcoal"]=1}, "#d2d2d2", {colorize_amount = 100})

register_dye("White", {["pmb_stone:limestone"]=1}, "#ffffff", {colorize_amount = 200})
