local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local pot_size = {
    type = "fixed",
    fixed = {-4/16, -8/16, -4/16, 4/16, -2/16, 4/16},
}

minetest.register_node('pmb_cooking:clay_crucible', {
    description = pmb_util.desc(S("Clay Crucible"), "grey"),
    _tt_long_desc = S("Cooks ores when placed above a lit furnace."),
    groups = { item_cooking_pot = 1, solid = 1, oddly_breakable_by_hand = 2, iron = 1, cooker = 1, cooker_boil = 1, cracky = 1, },
    drawtype = "mesh",
    use_texture_alpha = "opaque",
    paramtype = "light",
    paramtype2 = "facedir",
        tiles = {"pmb_cooking_pot_clay.png"},
        mesh = "pmb_clay_crucible.b3d",
    sounds = (pmb_sounds and pmb_sounds.default and pmb_sounds.default()) or {},
        collision_box = pot_size,
        selection_box = pot_size,
    _on_node_update = function(pos, cause, user, count)
        minetest.get_node_timer(pos):start(1.0)
    end,
    _on_cook = function(pos, node)
        for x=0, 10 do
            minetest.add_particle({
                pos = vector.offset(pos, math.random()-0.5, math.random()-0.5, math.random()-0.5),
                velocity = vector.new(0,math.random(),0),
                expirationtime = math.random() * 4,
                size = math.random() * 4,
                collisiondetection = false,
                vertical = false,
                texture = "pmb_cooking_particle_finished_cooking.png^[colorize:#ffffff55:200",
                glow = 14,
            })
            minetest.sound_play("pmb_cooking_finished_boil", {
                gain = 0.05,
                pos = pos,
                max_hear_distance = 5,
            })
        end
    end,
    _cook_group = function(pos)
        local below = minetest.get_node(vector.offset(pos, 0, -1, 0))
        if minetest.get_item_group(below.name, "melter") ~= 0
        or minetest.get_item_group(below.name, "lava") ~= 0 then
            return "cooker_crucible"
        else
            return nil
        end
    end,
        on_timer = pmb_cooking.cooker_node_timer,
    on_construct = pmb_cooking.cooker_on_construct,
    on_punch = function(pos, node, clicker, itemstack, pointed_thing)
        pmb_cooking.cooker_take_item(pos, node, clicker, itemstack, pointed_thing)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        return pmb_cooking.cooker_give_item(pos, node, clicker, itemstack, pointed_thing)
    end,
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true})
    end,
    _on_input_item = function(pos, itemstack)
        return pmb_cooking.cooker_offer_item(pos, itemstack)
    end,
})

-- temporary crafting recipe
if true then
        local s = "pmb_items:clay_ball"
        local g = "pmb_soil:sand"
        minetest.register_craft({
                output = "pmb_cooking:clay_crucible",
                recipe = {
                {s, "", s},
                {s,  g, s},
                {s,  s, s},
                },
        })
end
