local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node('pmb_underworld:glow_rock', {
  description = pmb_util.desc(S("Glow rock"), "green"),
  groups = { full_solid = 1, nature = 1,item_glow_rock = 1, underworld = 1, oddly_breakable_by_hand = 3, cracky = 1, magicky = 1, solid = 1, suffocates = 2, burns = 1, fuel = 600 },
  tiles = {"pmb_underworld_glowrock.png"},
  sounds = pmb_sounds.default_stone(),
  light_source = 14,
})
pmb_util.register_all_shapes("pmb_underworld:glow_rock")

local adjacent = {
  [0] = { x= 1, y= 0, z= 0 },
  [1] = { x=-1, y= 0, z= 0 },
  [2] = { x= 0, y= 0, z= 1 },
  [3] = { x= 0, y= 0, z=-1 },
  [4] = { x= 0, y= 1, z= 0 },
  [5] = { x= 0, y=-1, z= 0 },
}

local function has_adjacent(pos)
  for key, value in pairs(adjacent) do
    local node = minetest.get_node(vector.add(pos, value))
    if node.name == "air" then
      return true
    end
  end
  return false
end

function pmb_underworld.glow_rock_move(pos, node)
  local index = math.random(0, #adjacent)
  local new_pos = vector.add(pos, adjacent[index])
  local new_node = minetest.get_node(new_pos)
  if new_node.name == "pmb_underworld:lava_rock"
  and has_adjacent(new_pos) then
    minetest.set_node(new_pos, node)
    minetest.set_node(pos, new_node)
  end
end

