
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "desert_hills"

pmb_biomes.register_biome({
    name = this_biome,

    node_top = "pmb_soil:clay",
    depth_top = 1,

    node_filler = "pmb_soil:sand",
    depth_filler = 2,

    node_riverbed = "pmb_soil:sand",
    depth_riverbed = 3,

    y_max = sealevel + 120,
    y_min = sealevel + 10,
    y_min_ocean = sealevel - 80,

    heat_point = 80,
    humidity_point = 50,
}, {"desert", "overworld"})

local sch = pmb_sch.get_schematic_path

-------------------------------
--------- DECORATIONS ---------
-------------------------------
