
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min


minetest.register_decoration({
    name = "pmb_flora:glowroot_plant_1_1",
    deco_type = "simple",
    place_on = {"pmb_stone:loose_stone", "pmb_stone:granite"},
    sidelen = 16,
    noise_params = {
        offset = -0.04,
        scale = 0.1,
        spread = {x = 20, y = 20, z = 20},
        seed = 8567,
        octaves = 3,
        persist = 0.2
    },
    biomes = {
        "oak_forest_dense",
        "oak_forest_dense_ocean",
        "oak_forest_dense_1",
        "oak_forest_dense_1_ocean",
    },
    y_max = alt_max,
    y_min = sealevel - 10,
    decoration = "pmb_flora:glowroot_plant_1",
    -- flags = "all_floors"
})

minetest.register_decoration({
    name = "pmb_flora:glowroot_plant_4_1",
    deco_type = "simple",
    place_on = {"pmb_stone:loose_stone", "pmb_stone:granite"},
    sidelen = 16,
    noise_params = {
        offset = 0.008,
        scale = 0.05,
        spread = {x = 5, y = 5, z = 5},
        seed = 654,
        octaves = 2,
        persist = 0.1
    },
    biomes = {
        "grasslands",
        "grasslands_ocean",
        -- "taiga_tall",
        "taiga_tall_ocean",
        "taiga_tall_dense",
        "taiga_tall_dense_ocean",
    },
    y_max = sealevel + 10,
    y_min = sealevel - 30,
    decoration = "pmb_flora:glowroot_plant_4",
    flags = "all_floors"
})
minetest.register_decoration({
    name = "pmb_flora:glowroot_plant_4_2",
    deco_type = "simple",
    place_on = {"pmb_stone:loose_stone", "pmb_stone:granite"},
    sidelen = 16,
    noise_params = {
        offset = 0.005,
        scale = 0.01,
        spread = {x = 5, y = 5, z = 5},
        seed = 654,
        octaves = 2,
        persist = 0.1
    },
    biomes = {
        "grasslands",
        "grasslands_ocean",
    },
    y_max = alt_max,
    y_min = sealevel - 100,
    decoration = "pmb_flora:glowroot_plant_4",
    flags = "all_floors"
})
