function pmb_util.get_eyepos(player)
    local eyepos = vector.add(player:get_pos(), vector.multiply(player:get_eye_offset(), 0.1))
    eyepos.y = eyepos.y + 1.6
    return eyepos
end

function pmb_util.try_rightclick(itemstack, user, pointed_thing, dry)
    if not minetest.is_player(user) then return false end
    local pos = user:get_pos()
    pos = pmb_util.get_eyepos(user)

    local ctrl = user:get_player_control()
    if ctrl and ctrl.sneak then return false end

    if (not pointed_thing) or pointed_thing.type ~= "node" then
        local range = pmb_util.get_tool_range(itemstack)
        local ray = minetest.raycast(pos, vector.add(pos, vector.multiply(user:get_look_dir(), range)), false, false)
        pointed_thing = ray:next()
    end
    if (not pointed_thing) or pointed_thing.type ~= "node" then return false end
    local def = minetest.registered_nodes[minetest.get_node(pointed_thing.under).name]
    local on_rightclick = def and def.on_rightclick
    if on_rightclick == nil then
        return false
    end
    local node = minetest.get_node(pointed_thing.under)

    if not dry then
        itemstack = on_rightclick(pointed_thing.under, node, user, itemstack, pointed_thing) or itemstack
    end

    return itemstack
end
