local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

local uses

uses = 2048
minetest.register_tool("pmb_underworld:mythril_hammer", {
    description = pmb_util.desc(S("Mythril Hammer"), "grey"),
    inventory_image = "pmb_underworld_mythril_hammer.png",
    _tt_long_desc = S("Replaces nodes quickly without having to dig and fill nodes back in."),
    _tt_how_to_use = S("Paint: [place node]").."\n"..S("Pick: [dig]"),
    _tt_uses = uses,
    _uses = uses,
    tool_capabilities = {
        full_punch_interval = 2,
        groupcaps = {
            cracky = {
                maxlevel = 5,
                uses = uses,
            },
            crumbly = {
                maxlevel = 3,
                uses = uses,
            },
            choppy = {
                maxlevel = 3,
                uses = uses,
            },
            snappy = {
                maxlevel = 3,
                uses = uses,
            },
            magicky = {
                maxlevel = 2,
                uses = uses,
            },
        },
        damage_groups = {
            blunt=5,
        },
    },
    groups = { hammer = 3 },
    on_use = pmb_hammer.get_paint_node_from_pointed,
    on_place = pmb_hammer.paint_node,
})
if true then
    local m = "pmb_underworld:cortite_rod"
    local b = "pmb_underworld:mythril"
    minetest.register_craft({
        output = "pmb_underworld:mythril_hammer",
        recipe = {
        {b, m, b},
        {"",m,""},
        {"",m,""},
        },
    })
end
