local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local adjacent = {
    [0] = vector.new( 0,-1, 0),
    [1] = vector.new( 0, 1, 0),
    [2] = vector.new( 1, 0, 0),
    [3] = vector.new(-1, 0, 0),
    [4] = vector.new( 0, 0, 1),
    [5] = vector.new( 0, 0,-1),
}
local function get_adjacent_outputs(pos, exclude)
    local out = {}
    for i=0, #adjacent do
        local p = vector.add(pos, adjacent[i])
        if not vector.equals(p, exclude) then
            out[#out+1] = p
        end
    end
    return out
end


local formspec
do
    local fs, size = pmb_inventory.player.get_formspec(nil)
    local y = 12-size.y-2
    formspec = (
        "size[24.00,12.0]"..
        pmb_inventory.get_9patch(10, y-1.5, 2, 2, pmb_inventory.get_bg9patch_texture("#8e6e59"), "false", "32")..
        ((pmb_inventory and pmb_inventory.get_itemslot_array(10.5, y-1, 1, 1)) or "")..
        "list[context;main;10.5,"..tostring(y-1)..";1,1;]"..
        fs
    )
end


local function fix_formspec(pos)
    -- set up the formspec and stuff
    local meta = minetest.get_meta(pos)
    if meta:get_string("formspec") == formspec then return end
    meta:set_string("formspec", formspec)
    meta:set_string("infotext", "Distributor");
    local inv = meta:get_inventory()
    inv:set_size("main", 5)
    return true
end

minetest.register_node('pmb_pipes:distributor', {
    description = "Item Distributor",
    _tt_long_desc = S("Moves items equally to all adjacent inventories except the one it is facing away from coming from (red)."),
    groups = { full_solid = 1, cracky = 1, oddly_breakable_by_hand = 2, solid = 1, furniture = 1, suffocates = 0, pipe = 1, distributor = 1},
    tiles = {
        "pmb_pipes_distributor.png^[transformFY",
        "pmb_pipes_distributor.png",
        "pmb_pipes_distributor.png^[transformR90",
        "pmb_pipes_distributor.png^[transformR270",
        "pmb_pipes_distributor_front.png",
        "pmb_pipes_distributor_back.png",
    },
    -- tiles = {"pmb_pipes_distributor_back.png", "pmb_pipes_distributor_front.png", "pmb_pipes_distributor.png",},
    sounds = pmb_sounds.default_wood(),
    paramtype = "light",
    sunlight_propagates = true,
    paramtype2 = "facedir",
    connects_to = { "group:pipe", "group:storage", "group:chest", "group:cooker" },
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        pmb_util.rotate_and_place_against(pos, placer, itemstack, pointed_thing)
    end,
    on_timer = function(pos, elapsed)
        local from_pos = pmb_pipes.get_dir_of_node(pos)
        from_pos = vector.subtract(pos, from_pos)
        local outputs = get_adjacent_outputs(pos, from_pos)
        local ret = false
        for i=1, pmb_pipes.item_move_count*5 do
            ret = pmb_pipes.move_item_to(pos, outputs[i % (#outputs)+1], 1) or ret
        end
        if ret then
            local nt = minetest.get_node_timer(from_pos)
            if not nt:is_started() then
                nt:start(1)
            end
        end
        return ret
    end,
    on_construct = function(pos)
        -- tell the game what node it's pointing into
        local node = minetest.get_node(pos)
        local dir = minetest.facedir_to_dir(node.param2)
        pmb_pipes.set_meta_vector(pos, dir)
        fix_formspec(pos)
        -- start the timer
        minetest.get_node_timer(pos):start(1.0)
    end,
        on_destruct = function(pos)
        pmb_inventory.drop_contents(pos)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        fix_formspec(pos)
    end,
    _on_node_update = function(pos)
        if fix_formspec(pos) then return true end
    end,
    on_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
        pmb_pipes.start_timer(pos)
    end,
    on_metadata_inventory_put = function(pos, listname, index, stack, player)
        pmb_pipes.start_timer(pos)
    end,
    on_metadata_inventory_take = function(pos, listname, index, stack, player)
        pmb_pipes.start_timer(pos)
    end,
})

if true then
    local s = "pmb_items:copper_sheet"
    local p = "pmb_pipes:pipe"
    minetest.register_craft({
        output = "pmb_pipes:distributor 2",
        recipe = {
            {"", p, ""},
            { p,"", p},
            {"", p, ""},
        },
    })
end
