local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

local pipe_box1 = nil
local pipe_box = nil
if true then
    local pw = 6/16 -- width
    local pl = 8/16 -- length
    local pa = 4/16 -- length
    pipe_box1 = {
        type = "fixed",
        fixed = {
            -pa, -pa, -pa,
             pa,  pa,  pa
        },
    }
    pipe_box = {
        type = "connected",
        fixed = {
            -- {
            --     -pw*2,  pw-2/16, -pw*2,
            --      pw*2,  pw,       pw*2
            -- },
            {
                -pa, -pa, -pa,
                 pa,  pa,  pa
            },
        },
        connect_top = {
            -pw,  pl-4/16, -pw,
             pw,  pl,  pw
        },
        connect_bottom = {
            -pw, -pl, -pw,
             pw, -pl+4/16,  pw
        },
        connect_front = {
            -pw, -pw, -pl,
             pw,  pw, -pl+4/16
        },
        connect_left = {
            -pl, -pw, -pw,
            -pl+4/16,  pw,  pw
        },
        connect_back = {
            -pw, -pw,  pl-4/16,
             pw,  pw,  pl
        },
        connect_right = {
             pl-4/16, -pw, -pw,
             pl,  pw,  pw
        },
    }
end

local function get_filter(pos)
    local meta = minetest.get_meta(pos)
    local inv = meta:get_inventory()
    local out = {}
    local size = inv:get_size("filter")
    for i=1, size do
        local stack = inv:get_stack("filter", i)
        if not stack:is_empty() then
            out[#out+1] = stack:get_name()
        end
    end
    return out
end


local formspec = ""
do
    local fs, size = pmb_inventory.player.get_formspec(nil)
    local y = 12-size.y-2
    formspec = (
        "size[24.00,12.0]"..
        pmb_inventory.get_9patch(8, y-3.5, 6, 4, pmb_inventory.get_bg9patch_texture("#8e6e59"), "false", "32")..
        "image[10.2,"..tostring(y-2)..";2,1;pmb_pipes_text_filter.png]"..
        ((pmb_inventory and pmb_inventory.get_itemslot_array(8.5, y-1, 5, 1)) or "")..
        "list[context;filter;8.5,"..tostring(y-1)..";5,1;]"..
        ((pmb_inventory and pmb_inventory.get_itemslot_array(10.5, y-3, 1, 1)) or "")..
        "list[context;main;10.5,"..tostring(y-3)..";1,1;]"..
        fs
    )
end

local function fix_formspec(pos)
    -- set up the formspec and stuff
    local meta = minetest.get_meta(pos)
    if meta:get_string("formspec") == formspec then return end
    local inv = meta:get_inventory()
    inv:set_size("filter", 5)
    inv:set_size("main", 1)
    meta:set_string("formspec", formspec)
    meta:set_string("infotext", "Siphon");
    return true
end

minetest.register_node('pmb_pipes:siphon', {
    description = S("Pipe Siphon"),
    _tt_color = 3,
    _tt_long_desc = S("Takes items from any \"main\" inventory behind it if they match the filter,"..
        "and then puts them in the pipe or inventory it's facing."),
    groups = { cracky = 1, oddly_breakable_by_hand = 2, solid = 1, furniture = 1, suffocates = 0, pipe = 1, siphon = 1},
    tiles = {
        "pmb_pipes_siphon_top.png^[transformFY",
        "pmb_pipes_siphon_top.png",
        "pmb_pipes_siphon_top.png^[transformR90",
        "pmb_pipes_siphon_top.png^[transformR270",
        "pmb_pipes_siphon.png",
        "pmb_pipes_siphon.png",
    },
    -- tiles = {"pmb_pipes_siphon.png", "pmb_pipes_siphon.png", "pmb_pipes_siphon_top.png", "pmb_pipes_siphon_top.png",},
    sounds = pmb_sounds.default_wood(),
    paramtype = "light",
    sunlight_propagates = true,
    paramtype2 = "facedir",
    drawtype = "nodebox",
    node_box = pipe_box,
    connects_to = { "group:pipe", "group:storage", "group:chest", "group:cooker" },
    collision_box = pipe_box1,
    selection_box = pipe_box1,
    after_place_node = function(pos, placer, itemstack, pointed_thing)
        pmb_util.rotate_and_place_against(pos, placer, itemstack, pointed_thing)
    end,
    on_timer = function(pos, elapsed)
        local metavec = pmb_pipes.get_dir_of_node(pos)
        local to_pos = vector.add(pos, metavec)
        local from_pos = vector.subtract(pos, metavec)
        if (not to_pos) or (not pos) then return true end
        local filter = get_filter(pos)
        if #filter == 0 then filter = nil end
        local ret = false
        ret = pmb_pipes.move_item_to(pos, to_pos, pmb_pipes.item_move_count, {filter = filter}) or ret
        ret = pmb_pipes.move_item_to(from_pos, pos, pmb_pipes.item_move_count, {filter = filter}) or ret

        if not ret then
            ret = pmb_pipes.suck_up_items(from_pos, pos, pmb_pipes.item_move_count, {filter = filter})
        end

        -- siphon must be always active
        return true
    end,
    on_construct = function(pos)
        -- tell the game what node it's pointing into
        local node = minetest.get_node(pos)
        local dir = minetest.facedir_to_dir(node.param2)
        pmb_pipes.set_meta_vector(pos, dir)
        fix_formspec(pos)
        -- start the timer
        minetest.get_node_timer(pos):start(1.0)
    end,
        on_destruct = function(pos)
        pmb_inventory.drop_contents(pos)
    end,
    on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
        fix_formspec(pos)
    end,
    _on_node_update = function(pos)
        local nt = minetest.get_node_timer(pos)
        if not nt:is_started() then
            nt:start(1.0)
        end
        if fix_formspec(pos) then return true end
    end,
    on_metadata_inventory_move = function(pos, from_list, from_index, to_list, to_index, count, player)
        pmb_pipes.start_timer(pos)
    end,
    on_metadata_inventory_put = function(pos, listname, index, stack, player)
        pmb_pipes.start_timer(pos)
    end,
    on_metadata_inventory_take = function(pos, listname, index, stack, player)
        pmb_pipes.start_timer(pos)
    end,
})

if true then
    local p = "pmb_pipes:pipe"
    local d = "pmb_pipes:distributor"
    minetest.register_craft({
        output = "pmb_pipes:siphon 1",
        recipe = {
            {"", "pmb_items:iron_sheet"},
            {p, d},
        },
    })
end
