local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)



---------------------------------------------------
-----------------------STONE-----------------------
---------------------------------------------------

local enable_durability = minetest.settings:get("aom_tool_durability") == true

minetest.register_tool("pmb_tools:stone_pickaxe", {
    description = S("Stone Pickaxe"),
    -- _tt_uses = 64,
    inventory_image = "pmb_stone_pickaxe.png",
    tool_capabilities = pmb_util.register_tool_cap("pmb_tools:stone_pickaxe", {
        full_punch_interval = 1,
        groupcaps = {
            cracky = {
                max_drop_level = 3,
                times = { 0.5, 0.7, 1 },
                uses = ((not enable_durability) and 0) or 128,
            },
            choppy = {
                max_drop_level = 3,
                times = { 0.3 },
                uses = ((not enable_durability) and 0) or 128,
            },
            snappy = {
                max_drop_level = 3,
                times = { 0.3 },
                uses = ((not enable_durability) and 0) or 0,
            },
            crumbly = {
                max_drop_level = 3,
                times = { 0.225 },
                uses = ((not enable_durability) and 0) or 128,
            },
        },
        damage_groups = {
            pierce=2,
        },
    }),
    groups = { pickaxe = 2 },
})

minetest.register_tool("pmb_tools:stone_axe", {
    description = S("Stone Axe"),
    -- _tt_uses = 64,
    inventory_image = "pmb_stone_axe.png",
    tool_capabilities = pmb_util.register_tool_cap("pmb_tools:stone_axe", {
        full_punch_interval = 1,
        groupcaps = {
            choppy = {
                max_drop_level = 3,
                times = { 8 },
                uses = ((not enable_durability) and 0) or 64,
            },
            snappy = {
                max_drop_level = 3,
                times = { 0.25 },
                uses = ((not enable_durability) and 0) or 0,
            },
        },
        damage_groups = {
            slash=2,
            blunt=2,
        },
    }),
    groups = { axe = 2, treefeller = 1 },
})

---------------------------------------------------
-----------------------IRON------------------------
---------------------------------------------------

minetest.register_tool("pmb_tools:iron_pickaxe", {
    description = S("Iron Pickaxe"),
    _tt_color = 2,
    -- _tt_uses = 600,
    inventory_image = "pmb_iron_pickaxe.png",
    tool_capabilities = pmb_util.register_tool_cap("pmb_tools:iron_pickaxe", {
        full_punch_interval = 1,
        groupcaps = {
            cracky = {
                max_drop_level = 3,
                times = { 0.2, 0.2, 0.4 },
                uses = ((not enable_durability) and 0) or 600,
            },
            choppy = {
                max_drop_level = 3,
                times = { 0.3 },
                uses = ((not enable_durability) and 0) or 600,
            },
            snappy = {
                max_drop_level = 3,
                times = { 0.3 },
                uses = ((not enable_durability) and 0) or 0,
            },
            crumbly = {
                max_drop_level = 3,
                times = { 0.2 },
                uses = ((not enable_durability) and 0) or 600,
            },
        },
        damage_groups = {
            pierce=3,
        },
    }),
    groups = { pickaxe = 3 },
})

minetest.register_tool("pmb_tools:iron_axe", {
    description = S("Iron Axe"),
    _tt_color = 2,
    -- _tt_uses = 192,
    inventory_image = "pmb_iron_axe.png",
    tool_capabilities = pmb_util.register_tool_cap("pmb_tools:iron_axe", {
        full_punch_interval = 1,
        groupcaps = {
            choppy = {
                max_drop_level = 3,
                times = { 6 },
                uses = ((not enable_durability) and 0) or 600,
            },
            snappy = {
                max_drop_level = 3,
                times = { 0.15 },
                uses = ((not enable_durability) and 0) or 0,
            },
        },
        damage_groups = {
            slash=3,
            blunt=2,
        },
    }),
    groups = { axe = 3, treefeller = 1 },
})

---------------------------------------------------
----------------------BRONZE-----------------------
---------------------------------------------------

minetest.register_tool("pmb_tools:bronze_pickaxe", {
    description = S("Bronze Pickaxe"),
    _tt_color = 2,
    -- _tt_uses = 400,
    inventory_image = "pmb_bronze_pickaxe.png",
    tool_capabilities = pmb_util.register_tool_cap("pmb_tools:bronze_pickaxe", {
        full_punch_interval = 1,
        groupcaps = {
            cracky = {
                max_drop_level = 3,
                times = { 0.2, 0.2, 0.4 },
                uses = ((not enable_durability) and 0) or 400,
            },
            choppy = {
                max_drop_level = 3,
                times = { 0.3 },
                uses = ((not enable_durability) and 0) or 400,
            },
            snappy = {
                max_drop_level = 3,
                times = { 0.3 },
                uses = ((not enable_durability) and 0) or 0,
            },
            crumbly = {
                max_drop_level = 3,
                times = { 0.2 },
                uses = ((not enable_durability) and 0) or 400,
            },
        },
        damage_groups = {
            pierce=3,
        },
    }),
    groups = { pickaxe = 3 },
})

minetest.register_tool("pmb_tools:bronze_axe", {
    description = S("Bronze Axe"),
    _tt_color = 2,
    -- _tt_uses = 128,
    inventory_image = "pmb_bronze_axe.png",
    tool_capabilities = pmb_util.register_tool_cap("pmb_tools:bronze_axe", {
        full_punch_interval = 1,
        groupcaps = {
            choppy = {
                max_drop_level = 3,
                times = { 6 },
                uses = ((not enable_durability) and 0) or 128,
            },
            snappy = {
                max_drop_level = 3,
                times = { 0.15 },
                uses = ((not enable_durability) and 0) or 0,
            },
        },
        damage_groups = {
            pierce=3,
            slash=2,
        },
    }),
    groups = { axe = 3, treefeller = 1 },
})

---------------------------------------------------
---------------------DIAMOND-----------------------
---------------------------------------------------

minetest.register_tool("pmb_tools:diamond_pickaxe", {
    description = S("Diamond Pickaxe"),
    _tt_color = 3,
    -- _tt_uses = 5000,
    inventory_image = "pmb_diamond_pickaxe.png",
    tool_capabilities = pmb_util.register_tool_cap("pmb_tools:diamond_pickaxe", {
        full_punch_interval = 1,
        groupcaps = {
            magicky = {
                max_drop_level = 1,
                times = { 0.2, 0.3, 4, },
                uses = ((not enable_durability) and 0) or 5000,
            },
            cracky = {
                max_drop_level = 4,
                times = { 0.1, 0.1, 01, 1 },
                uses = ((not enable_durability) and 0) or 5000,
            },
            choppy = {
                max_drop_level = 3,
                times = { 0.1 },
                uses = ((not enable_durability) and 0) or 5000,
            },
            snappy = {
                max_drop_level = 3,
                times = { 0.1 },
                uses = ((not enable_durability) and 0) or 0,
            },
            crumbly = {
                max_drop_level = 3,
                times = { 0.1 },
                uses = ((not enable_durability) and 0) or 5000,
            },
        },
        damage_groups = {
            pierce=3,
        },
    }),
    groups = { pickaxe = 4 },
})

minetest.register_tool("pmb_tools:diamond_axe", {
    description = S("Diamond Axe"),
    _tt_color = 3,
    -- _tt_uses = 1024,
    inventory_image = "pmb_diamond_axe.png",
    tool_capabilities = pmb_util.register_tool_cap("pmb_tools:diamond_axe", {
        full_punch_interval = 1,
        groupcaps = {
            choppy = {
                max_drop_level = 3,
                times = { 3, 1.5, 1.5 },
                uses = ((not enable_durability) and 0) or 1024,
            },
            snappy = {
                max_drop_level = 3,
                times = { 0.1 },
                uses = ((not enable_durability) and 0) or 0,
            },
        },
        damage_groups = {
            slash=3,
            blunt=2,
        },
    }),
    groups = { axe = 4, treefeller = 1 },
})

dofile(mod_path .. DIR_DELIM .. "crafting.lua")
