local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)

local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_mirecaves.max
local alt_min = pmb_mirecaves.min

local w = pmb_mirecaves.worknodes

local size = 1

local this_biome = 'mirecaves'

size = 40

local np = {
    offset = sealevel+10,
    scale = 200,
    spread = {x = size, y = size, z = size},
    seed = 5643,
    octaves = 2,
}
local npt = {
    offset = 40,
    scale = 200,
    spread = {x = 60, y = 60, z = 60},
    seed = 900786,
    octaves = 4,
    persistence = 0.2
}

------------------- MASK for canyons using w.temp_node
-- USE WORKNODE
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = w.temp_node,
    wherein		= {"group:solid", "group:liquid", w.topsoil2},
    y_min = sealevel - 10,
    y_max = sealevel + 40,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})

-- put stone as a border near liquids
npt.offset = npt.offset * 2
-- leave top as topsoil
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = w.topsoil2,
    wherein		= {"group:liquid"},
    y_min = sealevel,
    y_max = sealevel,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "pmb_mirecaves:stone",
    wherein		= {"group:liquid", w.topsoil2},
    y_min = sealevel - 20,
    y_max = sealevel-1,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})

-- MASK for DEEPER steps in canyons using w.temp_node2
npt.offset = 0
npt.scale = 100
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = w.temp_node2,
    wherein		= {"group:solid", "group:liquid", w.topsoil2},
    y_min = sealevel - 10 - 10,
    y_max = sealevel + 10,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})



-- ACTUALLY MAKE CANYONS BY REPLACING WORKNODE
-- FIRST, do the mid level
size = 30
np = {
    offset = sealevel + 2 + 10,
    scale = 1,
    spread = {x = size, y = size, z = size},
    seed = 11234,
    octaves = 2,
}
npt = {
    offset = 40,
    scale = 3,
    spread = {x = 30, y = 30, z = 30},
    seed = 8753434,
    octaves = 2,
    persistence = 0.2
}
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "air",
    wherein		= {w.temp_node},
    y_min = sealevel - 50,
    y_max = sealevel + 50,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})

-- SOILS
np.offset = np.offset-1
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = w.topsoil2,
    wherein		= {w.temp_node},
    y_min = sealevel - 50,
    y_max = sealevel + 50,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})



-- NOW CLEAR DEEP LEVEL
np.offset = np.offset - 10 +1
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "air",
    wherein		= {w.temp_node2},
    y_min = sealevel - 50,
    y_max = sealevel + 50,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})

-- SOILS for deep level
np.offset = np.offset-1
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = w.topsoil2,
    wherein		= {w.temp_node2},
    y_min = sealevel - 50,
    y_max = sealevel + 50,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})


------------------- MESAs
local mesa_height = 30
size = 10
np = {
    offset = sealevel - 100,
    scale = 0,
    spread = {x = size, y = size, z = size},
    seed = 7565,
    octaves = 2,
}
npt = {
    offset = -200,
    scale = 510,
    spread = {x = 20, y = 20, z = 20},
    seed = 4690,
    octaves = 2,
    persistence = 0.01
}

minetest.register_ore({
    ore_type	= "stratum",
    ore		    = w.topsoil,
    wherein		= {"group:solid", "group:liquid", "air"},
    y_min = alt_min,
    y_max = sealevel + mesa_height,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})

size = 40
np = {
    offset = sealevel - 100,
    scale = 0,
    spread = {x = size, y = size, z = size},
    seed = 7565,
    octaves = 2,
}

np.offset = sealevel + mesa_height + 10
np.scale = 6
npt = {
    offset = 50,
    scale = 6,
    spread = {x = 30, y = 30, z = 30},
    seed = 864864,
    octaves = 2,
    persistence = 0.01
}
-- un-flatten tops
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = "air",
    wherein		= {w.topsoil},
    y_min = alt_min,
    y_max = sealevel + mesa_height + 10,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})
-- SOILS
np.offset = np.offset - 1
minetest.register_ore({
    ore_type	= "stratum",
    ore		    = w.topsoil2,
    wherein		= {w.topsoil},
    y_min = alt_min,
    y_max = sealevel + mesa_height + 10,
    noise_params = np,
    np_stratum_thickness = npt,
    biomes = {this_biome},
})
