local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

-- adds the usual default vals to the formspec
local function add_default(fs)
    table.insert(fs, "formspec_version[6]")
    table.insert(fs, "size[24.00,12.0]")
    table.insert(fs, "listcolors[#00000000;#00000000;#00000000;#111;#eee]")
    table.insert(fs, "bgcolor[#00000000]")
    -- table.insert(fs, "bgcolor[#000000a0]")
    table.insert(fs, "style_type[item_image_button;bgcolor=#fff;bgcolor_hovered=#fff;bgcolor_pressed=#fff]")
    table.insert(fs, "style_type[item_image_button;textcolor=#8c3f5d;border=false]")
    table.insert(fs, "style_type[button;bgimg=pmb_inv_btn.png\\^\\[multiply:#616161;bgimg_middle=8;"..
    "bgimg_hovered=pmb_inv_btn.png\\^\\[multiply:#616161;bgimg_pressed=pmb_inv_btn_press.png\\^\\[multiply:#616161;"..
    "bgcolor_hovered=#eee;bgcolor_pressed=#fff]".."style_type[button;border=false]")
end

local function do_sound_click(player, sound)
    minetest.sound_play((sound), {
        gain = 1 * aom_igm.get_setting(player, "sound_menu_volume"),
        to_player = player:get_player_name(),
    })
end


-- MAIN MENU
aom_igm.register_page_process("main", function(player, pagename, fs)
    add_default(fs)
    -- main menu title
    table.insert(fs, "box[10,0;4,12;#111111e0]")
    table.insert(fs, "label[11.2,2.4;Player Menu]")
    table.insert(fs, "image[9.6,0.2;4.8,2.0;aom_igm_title.png]")
    -- main buttons
    table.insert(fs, "container[12,4]")
    table.insert(fs, "button[-2.2,0;4.4,1;settings;"..S("settings").."]")
    table.insert(fs, "container_end[]")
end)

aom_igm.register_page_action("main", function(player, pagename, fields)
    if fields.settings then
        do_sound_click(player, "aom_igm_click")
        aom_igm.show_page(player, "settings")
    end
end)


local type_colors = {
    boolean = "#f58",
    number = "#4af",
    string = "#2f5",
}

-- SETTINGS MENU
aom_igm.register_page_process("settings", function(player, pagename, fs)
    aom_igm.check_player(player)
    local pi = aom_igm.player_meta[player]

    add_default(fs)

    table.insert(fs, "box[5,0;13,12;#111111e0]")
    -- delete all button
    table.insert(fs,    "box[5.5,9.1;2,1.2;#ff556680]")
    table.insert(fs, "button[5.6,9.2;1.8,1;reset_all;"..S("reset all").."]")
    -- back buttons
    table.insert(fs, "button[5.1,0.1;1.8,1;back;"..S("back").."]set_focus[back;false]")

    -- SETTINGS label
    table.insert(fs, "label[8,1.2;These are local to your player character on this world and are sent to the server.]")
    table.insert(fs, "style_type[label;font_size=*0.8;textcolor=#aaa]")
    table.insert(fs, "label[5.2,2.75;Inputting an invalid value]")
    table.insert(fs, "label[5.2,3;will reset it to its default value.]")
    table.insert(fs, "style_type[label;font_size=*2;textcolor=#fea;font=bold]")
    table.insert(fs, "label[8,0.7;PLAYER SETTINGS]")

    local maxscroll = #aom_igm.registered_settings_array * 10 * 1.2 - 60
    -- scroll container
    table.insert(fs, "scrollbaroptions[arrows=hide;smallstep=10"..
        ";thumbsize=10;max="..tostring(maxscroll).."]")
    table.insert(fs, "box[8.5,1.5;8,10;#333333c0]")
    table.insert(fs, "scroll_container[8.5,1.5;8,10;scroll;vertical;0.1]")

    table.insert(fs, "style_type[label;font_size=*0.8;textcolor=#ddd;font=normal]")
    table.insert(fs, "style_type[image_button;border=false]")

    local last_col = "#ddd"

    local y = 0.5
    local rowindex = 1
    for catname, settinglist in pairs(aom_igm.registered_settings_by_category) do
        local color = "#111"
        local ysize = #settinglist * 1.2 + 1.1
        table.insert(fs, "box[0.5,"..(y+0.2)..";7,"..ysize..";"..color.."]")
        table.insert(fs, "style_type[label;font_size=*1.5;textcolor=#fff;font=bold]")
        table.insert(fs, "label[1,"..tostring(y+0.6)..";"..catname.."]")
        table.insert(fs, "style_type[label;font_size=*0.8;textcolor=#ddd;font=normal]")
        rowindex = rowindex * -1
        y = y + 1.3
        for i, settingidef in ipairs(aom_igm.registered_settings_by_category[catname]) do
            local def = settingidef.def
            local settingname = settingidef.name
            local currentval = aom_igm.get_setting(player, settingname)
            -- table.insert(fs, "")
            -- color based on type
            local col = type_colors[def.type] or "#ddd"
            if col ~= last_col then
                table.insert(fs, "style_type[label;textcolor="..col.."]")
            end
            local is_default = (aom_igm.player_meta[player].settings[settingname] == nil)
            table.insert(fs, "label[0.75,"..(y+0.3)..";"..def.type.."]")
            table.insert(fs, "field[1.75,"..(y)..";5,0.8;set:"..settingname..";"..settingname..";"..tostring(currentval).."]")
            table.insert(fs, "field_close_on_enter[set:"..settingname..";false]")
            if pi.last_setting_set == "set:"..settingidef.name then
                table.insert(fs, "image[6.2,"..(y+0.15)..";0.5,0.5;aom_igm_tick.png]")
            end
            if not is_default then
                table.insert(fs, "image_button[6.8,"..(y+0.15)..";0.5,0.5;".."aom_igm_reset.png;".."reset:"..settingname.."; ]")
            end
            y = y + 1.2
        end
    end

    table.insert(fs, "scroll_container_end[]")
    table.insert(fs, "scrollbar[8,1.5;0.5,10;vertical;scroll;"..tostring(pi.last_scroll or 0).."]")
end)

aom_igm.register_page_action("settings", function(player, pagename, fields)
    aom_igm.check_player(player)
    local pi = aom_igm.player_meta[player]

    if fields.back then
        pi.last_setting_set = nil
        do_sound_click(player, "aom_igm_click")
        return aom_igm.show_page(player, "main")
    end
    if fields.reset_all then
        pi.settings = {}
        pi.last_setting_set = nil
        aom_igm.save_player(player)
        minetest.sound_play("aom_igm_click", {
            gain = 1 * aom_igm.get_setting(player, "sound_menu_volume"),
            pitch = 0.8,
            to_player = player:get_player_name(),
        })
        return aom_igm.show_page(player, pagename)
    end

    if fields.scroll then
        local scroll = minetest.explode_scrollbar_event(fields.scroll)
        pi.last_scroll = ((scroll.type == "CHG") and scroll.value) or pi.last_scroll
    end

    for key, value in pairs(fields) do repeat
        local action = string.split(key, ":")
        if (not action) or #action < 2 then break end
        local setting = aom_igm.registered_settings[action[2]]
        if (setting ~= nil) and (value ~= "") then
            if action[1] == "reset" then
                aom_igm.set_setting(player, action[2], nil)
                aom_igm.show_page(player, pagename)
                minetest.sound_play("aom_igm_click", {
                    gain = 1 * aom_igm.get_setting(player, "sound_menu_volume"),
                    pitch = 0.8,
                    to_player = player:get_player_name(),
                })
            elseif key == fields.key_enter_field then
                do_sound_click(player, "aom_igm_click")
                pi.last_setting_set = key
                aom_igm.set_setting(player, action[2], value)
            end
        end
    until true end

    if fields.key_enter then
        aom_igm.show_page(player, pagename)
    end
end)

-- debug
-- minetest.register_on_joinplayer(function(player, last_login)
--     aom_igm.show_page(player, "main")
-- end)
