local mod_name = minetest.get_current_modname()
local S = minetest.get_translator(mod_name)

minetest.register_node("pmb_underworld:mythrite", {
    description = S("Mythrite"),
    _tt_color = 3,
    groups = { full_solid = 1, item_mythrite = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light + 2,
    paramtype = "light",
})
if true then
    local s = "pmb_underworld:lava_rock"
    local m = "pmb_underworld:mythril_strand"
    minetest.register_craft({
        output = "pmb_underworld:mythrite 8",
        recipe = {
        {s, s, s},
        {s, m, s},
        {s, s, s},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:mythrite")


minetest.register_node('pmb_underworld:mythrite_brick', {
    description = S("Mythrite Bricks"),
    _tt_color = 3,
    groups = { full_solid = 1, item_mythrite_brick = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite_brick.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light + 2,
    paramtype = "light",
})
if true then
    local s = "pmb_underworld:mythrite"
    minetest.register_craft({
        output = "pmb_underworld:mythrite_brick 4",
        recipe = {
        {s, s},
        {s, s},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:mythrite_brick")


minetest.register_node('pmb_underworld:mythrite_lamp', {
    description = S("Mythrite Lamp"),
    _tt_color = 3,
    groups = { full_solid = 1, item_mythrite_lamp = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 2, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite_lamp.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = 14,
    paramtype = "light",
})
if true then
    local s = "pmb_underworld:mythrite_brick"
    local g = "pmb_underworld:glow_rock"
    minetest.register_craft({
        output = "pmb_underworld:mythrite_lamp 6",
        recipe = {
        {s, s, s},
        {s, g, s},
        {s, s, s},
        },
    })
end
minetest.register_node('pmb_underworld:mythrite_brick_fine', {
    description = S("Fine Mythrite Bricks"),
    groups = { full_solid = 1, item_mythrite_brick_fine = 1, underworld = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite_brick_fine.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light + 2,
    paramtype = "light",
})
if true then
    local s = "pmb_underworld:mythrite"
    local g = "pmb_underworld:mythrite_brick"
    minetest.register_craft({
        output = "pmb_underworld:mythrite_brick_fine 4",
        recipe = {
        {s, s},
        {g, g},
        {g, g},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:mythrite_brick_fine")


minetest.register_node('pmb_underworld:mythrite_brick_pillar', {
    description = S("Mythrite Brick Pillar"),
    _tt_color = 3,
    groups = { full_solid = 1, item_mythrite_brick_pillar = 1, oddly_breakable_by_hand = 3, magicky = 1, solid = 1, suffocates = 2 },
    tiles = {"pmb_underworld_mythrite_brick_pillar_top.png", "pmb_underworld_mythrite_brick_pillar_top.png", "pmb_underworld_mythrite_brick_pillar.png"},
    sounds = pmb_sounds.default_stone(),
    light_source = pmb_underworld.lava_rock_light + 2,
    paramtype = "light",
    paramtype2 = "facedir",
    on_place = pmb_util.rotate_and_place,
})
if true then
    local g = "pmb_underworld:mythrite_brick"
    minetest.register_craft({
        output = "pmb_underworld:mythrite_brick_pillar 3",
        recipe = {
        {g},
        {g},
        {g},
        },
    })
end
pmb_util.register_all_shapes("pmb_underworld:mythrite_brick_pillar")
