
local grassnodelist = {
    "pmb_flora:grass_0",
    "pmb_flora:grass_1",
    "pmb_flora:grass_2",
    "pmb_flora:grass_3",
}

local function get_random_grass()
    return grassnodelist[math.random(1, #grassnodelist)]
end

local np = {
    offset = 0.4,
    scale = 0.5,
    spread = {x = 2, y = 2, z = 2},
    seed = 54256 + (minetest.get_mapgen_setting("seed") or 0),
    octaves = 2,
    persist = 0.1,
    lacunarity = 2.317,
}

local iperlin = PerlinNoise(np)

local mg_name = minetest.get_mapgen_setting("mg_name")
if mg_name and (mg_name ~= "flat") and (mg_name ~= "singlenode") then
    minetest.register_abm({
        nodenames = {"group:grass_block"},
        -- interval = 2.0,
        -- chance = 1,
        interval = 30.0,
        chance = 300,
        action = function(pos, node, active_object_count, active_object_count_wider)
            if iperlin:get_3d(pos) < 0.5 then return end
            local b = minetest.get_node(pos)
            if minetest.get_item_group(b.name, "full_solid") == 0 then return end
            local p = vector.new(pos.x, pos.y+1, pos.z)
            if (minetest.get_node_light(p, 0.5) or 0) < 4 then return end
            local n = minetest.get_node(p)
            if (n.name ~= "air") then return end
            local shape = math.random(0,3)
            minetest.set_node(p, {
                name=get_random_grass(),
                param2=shape+8+(math.random(0,1)*16)
            })
        end
    })
end