local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


aom_creative = {}
aom_creative.disable_take_item = false

-- don't take items when in creative if it's the last item
local core_item_place = minetest.item_place_node
minetest.item_place_node = function(itemstack, placer, pointed_thing, param2, prevent_after_place)
    local ret, pos = core_item_place(ItemStack(itemstack), placer, pointed_thing, param2, prevent_after_place)
    if minetest.is_creative_enabled(placer:get_player_name()) and ret:is_empty() then
        return itemstack, pos
    else
        return (aom_creative.disable_take_item and itemstack or ret), pos
    end
end
