



# Usage
In normal use for players, they just type /menu to open the menu. For compatibility, you can do the following after adding optional or full dependency.
```lua
local function play_music(player, track)
    local volume = 1
    if minetest.get_modpath("aom_settings") then
        volume = aom_settings.get_setting(player, "music_volume") or 1
    end
    if volume <= 0 then return end
    minetest.sound_play(track, {
        gain = volume,
        to_player = player:get_player_name(),
    })
end
```

This allows you to have player based settings, which can be configurable ingame via formspecs.


