
local vmax = pmb_underworld.alt_max
local vmin = pmb_underworld.alt_min

local size = 50

local c = math.floor(math.abs(vmax - vmin)/100)
local thickness = -30
local craziness = 30

for i=0, c do
  minetest.register_ore({
    ore_type       = "stratum",
    ore            = "pmb_underworld:obsidian",
    wherein        = {"air"},
    y_min = vmin,
    y_max = vmax,
    clust_scarcity  = 1,
    noise_params    = {
      offset = vmin + ((vmax - vmin) * i / c) + 100,
      scale = (vmax - vmin) / (c*2),
      spread = {x = size, y = size, z = size},
      seed = 559 + i*137,
      octaves = 1,
    },
    np_stratum_thickness = {
      offset = thickness,
      scale = craziness,
      spread = {x = 100, y = 100, z = 100},
      seed = 45324378 + i * 3,
      octaves = 3,
      persistence = 0.7
    },
    stratum_thickness = 20,
    biomes = {},
  })
end