local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)

-- adds the usual default vals to the formspec
function aom_igm.add_formspec_defaults(fs)
    table.insert(fs, "formspec_version[6]")
    table.insert(fs, "size[24.00,12.0]")
    table.insert(fs, "listcolors[#00000000;#00000000;#00000000;#111;#eee]")
    table.insert(fs, "bgcolor[#00000000]")
    -- table.insert(fs, "bgcolor[#000000a0]")
    table.insert(fs, "style_type[item_image_button;bgcolor=#fff;bgcolor_hovered=#fff;bgcolor_pressed=#fff]")
    table.insert(fs, "style_type[item_image_button;textcolor=#8c3f5d;border=false]")
    table.insert(fs, "style_type[button;bgimg=pmb_inv_btn.png\\^\\[multiply:#616161;bgimg_middle=8;"..
    "bgimg_hovered=pmb_inv_btn.png\\^\\[multiply:#616161;bgimg_pressed=pmb_inv_btn_press.png\\^\\[multiply:#616161;"..
    "bgcolor_hovered=#eee;bgcolor_pressed=#fff]".."style_type[button;border=false]")
end

local has_settings = minetest.get_modpath("aom_settings") ~= nil
function aom_igm.get_setting(player, name, default)
    if has_settings then return aom_settings.get_setting(player, name) or default
    else return default end
end

function aom_igm.do_sound_click(player, sound)
    minetest.sound_play((sound), {
        gain = 1 * aom_igm.get_setting(player, "sound_menu_volume", 1),
        to_player = player:get_player_name(),
    })
end


-- MAIN MENU
aom_igm.register_page_process("main", function(fs, player, pagename)
    aom_igm.add_formspec_defaults(fs)
    -- main menu title
    table.insert(fs, "box[10,0;4,12;#111111e0]")
    table.insert(fs, "label[11.2,2.4;Player Menu]")
    table.insert(fs, "image[9.6,0.2;4.8,2.0;aom_igm_title.png]")
    -- table.insert(fs, "container_end[]")
end)

minetest.register_on_mods_loaded(function()
    aom_igm.register_page_process("main", function(fs, player, pagename)
        table.insert(fs, "container_end[]")
    end)
end)

aom_igm.register_page_action("main", function(player, pagename, fields)
    if fields.settings then
        aom_igm.do_sound_click(player, "aom_igm_click")
        aom_igm.show_page(player, "settings")
    end
    if fields.server then
        aom_igm.do_sound_click(player, "aom_igm_click")
        aom_igm.show_page(player, "server")
    end
end)
