local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


local tiles = {{name = "pmb_lights_torch.png",
    backface_culling = false,
    animation = {type="vertical_frames", aspect_w = 14, aspect_h = 10, length = 2.0}
}}

local timer_max = 2

local has_aom_settings = minetest.get_modpath("aom_settings") ~= nil

local function particles(pos)
    local particles_amount = 10
    if has_aom_settings then
        particles_amount = aom_settings.get_setting(nil, "performance_torch_particles", 10)
    end
    if particles_amount <= 0 then return end
    local node = minetest.get_node(pos)
    local dir = minetest.facedir_to_dir(node.param2)
    pos = pos + (dir * 0.1)
    minetest.add_particlespawner({
        amount = particles_amount,
        time = timer_max,
        collisiondetection = true,
        collision_removal = false,
        object_collision = false,
        -- attached = self.object, -- to object ref
        vertical = false, -- If true face player using y axis only:-- If true face player using y axis only:
        texture = "pmb_lights_torch_smoke.png",
        texpool = {
            {
                name = "pmb_lights_torch_smoke.png^[multiply:#223",
                alpha_tween = {
                    0.0, 1.0,
                    style = "pulse",
                },
                animation = {
                    type = "vertical_frames",
                    aspect_w = 16, aspect_h = 16,
                    length = 2,
                },
            },
        },
        -- glow = 0,
        minpos = vector.new(-0.1,  0.0+0.3, -0.1) + pos,
        maxpos = vector.new( 0.1,  0.1+0.3,  0.1) + pos,
        minvel = vector.new(-0.1,  1.0, -0.1),
        maxvel = vector.new( 0.1,  1.2,  0.1),
        minexptime = 1,
        maxexptime = 4,
        minsize = 1,
        maxsize = 5,
    })
    minetest.add_particlespawner({
        amount = particles_amount,
        time = timer_max,
        collisiondetection = true,
        collision_removal = false,
        object_collision = false,
        -- attached = self.object, -- to object ref
        vertical = false, -- If true face player using y axis only:-- If true face player using y axis only:
        texture = "blank.png^[noalpha^[colorize:#fb6:255",
        texpool = {
            {
                name = "blank.png^[noalpha^[colorize:#fb6:255",
                alpha_tween = {
                    0.0, 1.0,
                    style = "pulse",
                },
            },
        },
        -- glow = 0,
        minpos = vector.new(-0.1,  0.0+0.3, -0.1) + pos,
        maxpos = vector.new( 0.1,  0.1+0.3,  0.1) + pos,
        minvel = vector.new(-0.1,  1.0, -0.1),
        maxvel = vector.new( 0.1,  2.2,  0.1),
        minexptime = 1,
        maxexptime = 2,
        minsize = 0.2,
        maxsize = 0.7,
    })
end

minetest.register_node("pmb_lights:torch", {
    description = S("Torch"),
    light_source = 12,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "aom_torch.b3d",
    use_texture_alpha = "clip",
    tiles = tiles,
    walkable = false,
    groups = { dig_immediate = 3, deco_block = 1, furniture = 1, torch = 1, },
    sounds = pmb_sounds.default_wood(),
    -- paramtype2 = "facedir",
	selection_box = {
		type = "fixed",
		fixed = {-3/16, -8/16, -3/16, 3/16, 0/16, 3/16},
	},
    on_place = function(itemstack, placer, pointed_thing)
        local dir = vector.subtract(pointed_thing.under, pointed_thing.above)
        if dir.y == 1 then return itemstack end
        local retpos = nil
        itemstack, retpos = pmb_util.rotate_and_place_against(itemstack, placer, pointed_thing)
        return itemstack
    end,
    on_construct = function(pos)
        particles(pos)
        local nt = minetest.get_node_timer(pos)
        nt:start(timer_max)
    end,
    on_timer = function(pos, elapsed)
        particles(pos)
        local nt = minetest.get_node_timer(pos)
        nt:start(timer_max)
    end,
    _on_node_update = pmb_lights.on_node_update,
    _wall = "pmb_lights:torch_wall",
    _floor = "pmb_lights:torch",
})

minetest.register_node("pmb_lights:torch_wall", {
    description = S("Torch"),
    light_source = 12,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "aom_torch_wall.b3d",
    use_texture_alpha = "clip",
    tiles = tiles,
    drop = "pmb_lights:torch",
    walkable = false,
    groups = { dig_immediate = 3, deco_block = 1, furniture = 1, torch = 1, },
    sounds = pmb_sounds.default_wood(),
    paramtype2 = "facedir",
	selection_box = {
		type = "fixed",
		fixed = {-3/16, -3/16, 4/16, 3/16, 6/16, 8/16},
	},
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true,})
    end,
    on_construct = function(pos)
        particles(pos)
        local nt = minetest.get_node_timer(pos)
        nt:start(timer_max)
    end,
    on_timer = function(pos, elapsed)
        particles(pos)
        local nt = minetest.get_node_timer(pos)
        nt:start(timer_max)
    end,
    _on_node_update = pmb_lights.on_node_update,
    _wall = "pmb_lights:torch_wall",
    _floor = "pmb_lights:torch",
})

if minetest.get_modpath("pmb_tcraft") then
    pmb_tcraft.register_group_craft({
        output = "pmb_lights:torch 4",
        items = {
            ["pmb_items:stick"] = 4
        },
        group = "coal",
        group_count = 1
    })
end
