
local sealevel = pmb_vars.overworld.sea_level
local alt_max = pmb_vars.overworld.alt_max
local alt_min = pmb_vars.overworld.alt_min

-------------------------------
------------ BIOME ------------
-------------------------------

local this_biome = "boulder_valley"

pmb_biomes.register_biome({
    name = this_biome,

    node_top = 'pmb_soil:forest_dirt',--_with_grass',
    depth_top = 1,

    node_filler = 'pmb_soil:dirt',
    depth_filler = 5,

    node_riverbed = 'pmb_soil:sand',
    depth_riverbed = 3,

    y_max = sealevel + 30,
    y_min = sealevel + 1,
    y_min_ocean = sealevel - 80,
    vertical_blend = 9,

    heat_point = 29,
    humidity_point = 6,
}, {"light_scrub", "ash", "boulders", "overworld"})

-------------------------------
--------- DECORATIONS ---------
-------------------------------

local sch = pmb_sch.get_schematic_path


-- ORES

minetest.register_ore({
    ore_type	= "blob",
    ore		    = "pmb_stone:cobble",
    wherein		= {"group:soil"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_min		= -100,
    y_max		= 3000,
    noise_params = {
        offset  = 0.01,
        scale   = 1,
        spread  = {x=250, y=250, z=250},
        seed    = 12345,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
        flags = "defaults",
    },
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "pmb_stone:cobble",
    wherein		= {"group:soil"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "blob",
    ore		    = "pmb_stone:stone",
    wherein		= {"group:soil"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    noise_params = {
        offset  = 0.01,
        scale   = 1,
        spread  = {x=20, y=250, z=20},
        seed    = 67576,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
        flags = "defaults",
    },
    biomes = {this_biome},
})

minetest.register_ore({
    ore_type	= "blob",
    ore		    = "pmb_stone:cobble_moss_1",
    wherein		= {"pmb_soil:forest_dirt"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    noise_params = {
        offset  = 0.01,
        scale   = 1,
        spread  = {x=20, y=250, z=20},
        seed    = 453,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
        flags = "defaults",
    },
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "pmb_stone:cobble_moss_1",
    wherein		= {"pmb_stone:cobble"},
    clust_scarcity	= 250,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})
minetest.register_ore({
    ore_type	= "scatter",
    ore		    = "pmb_stone:cobble_moss_2",
    wherein		= {"pmb_stone:cobble_moss_1"},
    clust_scarcity	= 350,
    clust_num_ores	= 40,
    clust_size	= 5,
    y_max = alt_max,
    y_min = sealevel,
    biomes = {this_biome},
})



-- trees
if true then
    -- oak
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    noise_params = {
        offset = 0.0001,
        scale = 0.0015,
        spread = {x = 10, y = 10, z = 10},
        seed = 654,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    noise_params = {
        offset = 0.0001,
        scale = 0.0025,
        spread = {x = 4, y = 4, z = 4},
        seed = 654,
        octaves = 1,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    noise_params = {
        offset = 0.0001,
        scale = 0.0025,
        spread = {x = 4, y = 4, z = 4},
        seed = 654,
        octaves = 1,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_huge_2"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    noise_params = {
        offset = 0.0015,
        scale = 0.0030,
        spread = {x = 10, y = 10, z = 10},
        seed = 7856,
        octaves = 3,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_oak_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1,
})
-- ash
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    noise_params = {
        offset = 0.002,
        scale = 0.004,
        spread = {x = 6, y = 6, z = 6},
        seed = 64758,
        octaves = 2,
        persistence = 0.2,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
})
minetest.register_decoration({
    deco_type = "schematic",
    place_on = {"group:soil"},
    sidelen = 16,
    noise_params = {
        offset = -0.05,
        scale = 0.1,
        spread = {x = 4, y = 4, z = 4},
        seed = 64758,
        octaves = 2,
        persistence = 0.7,
        lacunarity = 2.0,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    schematic = sch("tree_ash_bush_0"),
    flags = "place_center_x, place_center_z",
    rotation = "random",
    place_offset_y = 1
})
end



minetest.register_decoration({
    deco_type = "simple",
    place_on = {"group:soil"},
    sidelen = 1,
    noise_params = {
        offset = -0.55,
        scale = 0.7,
        spread = {x = 16, y = 16, z = 16},
        seed = 5546,
        octaves = 2,
        persist = 0.2,
        lucanarity = 2.78,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    decoration = "pmb_flora:shrub_0",
})
minetest.register_decoration({
    deco_type = "simple",
    place_on = {"group:soil"},
    sidelen = 1,
    noise_params = {
        offset = -0.6,
        scale = 0.7,
        spread = {x = 16, y = 16, z = 16},
        seed = 5546,
        octaves = 2,
        persist = 0.2,
        lucanarity = 2.78,
    },
    biomes = {this_biome},
    y_max = alt_max,
    y_min = sealevel,
    decoration = "pmb_flora:shrub_1",
})



pmb_biomes.add_boulders({
    biomes = {this_biome},
    place_on = {"group:soil", "group:stone"},
    chance = 1,
    height_offset = 1,
    np = {
        offset  = -0.001,
        scale   = 0.007,
        spread  = {x=4, y=4, z=4},
        seed    = 12345,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
    },
})
pmb_biomes.add_boulders({
    biomes = {this_biome},
    place_on = {"group:soil", "group:stone"},
    chance = 1,
    height_offset = -4,
    np = {
        offset  = -0.001,
        scale   = 0.006,
        spread  = {x=4, y=4, z=4},
        seed    = 12345,
        octaves = 3,
        persist = 0.6,
        lacunarity = 2,
    },
})

local function do_rush_grass_stuff(num, seed, offset)
    minetest.register_decoration({
        deco_type = "simple",
        place_on = {"group:soil"},
        sidelen = 1,
        noise_params = {
            offset = -7 + (offset or 0),
            scale = 8,
            spread = {x = 16, y = 16, z = 16},
            seed = seed,
            octaves = 2,
            persist = 0.8,
            lucanarity = 2.78,
        },
        biomes = {this_biome},
        y_max = alt_max+1,
        y_min = sealevel,
        decoration = "pmb_flora:rush_grass_"..num,
    })
end

do_rush_grass_stuff(1, 5546)
do_rush_grass_stuff(0, 5546, 2)

