local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


pmb_stone = {}


minetest.register_node("pmb_stone:stone", {
    description = S("Stone"),
    _tt_long_desc = S("What type of stone? Yes."),
    groups = {
        full_solid = 1, nature = 1, stone = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1, silk_touchable = 1, natural_stone = 1 },
    tiles = { "pmb_stone_stone.png" },
    drop = "pmb_stone:cobble",
    sounds = pmb_sounds.default_stone(),
    -- light_source = 10,
}) pmb_util.register_all_shapes("pmb_stone:stone")

minetest.register_node("pmb_stone:sandstone", {
    description = S("Sandstone"),
    _tt_long_desc = S(""),
    groups = {
        full_solid = 1, nature = 1, sandstone = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, natural_stone = 1 },
    tiles = { "pmb_stone_sandstone.png" },
    sounds = pmb_sounds.default_stone(),
}) pmb_util.register_all_shapes("pmb_stone:sandstone", {}, {remove_groups={"natural_stone"}})

minetest.register_node("pmb_stone:granite", {
    description = S("Granite"),
    groups = {
        full_solid = 1, nature = 1, granite = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, natural_stone = 1 },
    tiles = { "pmb_stone_granite.png" },
    sounds = pmb_sounds.default_stone(),
}) pmb_util.register_all_shapes("pmb_stone:granite", {}, {remove_groups={"natural_stone"}})

minetest.register_node("pmb_stone:limestone", {
    description = S("Limestone"),
    groups = {
        full_solid = 1, nature = 1, limestone = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, natural_stone = 1 },
    tiles = { "pmb_stone_limestone.png" },
    sounds = pmb_sounds.default_stone(),
}) pmb_util.register_all_shapes("pmb_stone:limestone", {}, {remove_groups={"natural_stone"}})

minetest.register_node("pmb_stone:limestone_cobble", {
    description = S("Cobbled Limestone"),
    groups = {
        full_solid = 1, nature = 1, limestone_cobble = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1, stone = 1 },
    tiles = { "pmb_stone_limestone_cobble.png" },
    sounds = pmb_sounds.default_stone(),
}) pmb_util.register_all_shapes("pmb_stone:limestone_cobble")
minetest.register_craft({
        output = "pmb_stone:limestone_cobble",
        recipe = {{"pmb_stone:limestone"}},
})

minetest.register_node("pmb_stone:cobble", {
    description = S("Cobblestone"),
    groups = {
        full_solid = 1, nature = 1, cobble = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, natural_stone = 1},
    tiles = { "pmb_stone_cobble.png" },
    sounds = pmb_sounds.default_stone(),
}) pmb_util.register_all_shapes("pmb_stone:cobble", {}, {remove_groups={"cobble"}})

pmb_tcraft.register_craft({
    output = "pmb_stone:stone 10",
    items = {
        ["pmb_stone:cobble"] = 10,
    }
})

minetest.register_node("pmb_stone:cobble_moss_1", {
    description = S("Slightly Mossy Cobble"),
    groups = {
        full_solid = 1, nature = 1, cobble_moss_1 = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1, stone = 1, mossy_stone = 1, },
    tiles = { "pmb_stone_cobble.png^pmb_stone_cobble_moss_1.png" },
    drop = "pmb_stone:cobble_moss_1",
    sounds = pmb_sounds.default_stone(),
}) pmb_util.register_all_shapes("pmb_stone:cobble_moss_1")

pmb_tcraft.register_craft({
    output = "pmb_stone:cobble_moss_1 10",
    extra_items = {
        "pmb_items:wooden_cup",
    },
    items = {
        ["pmb_items:wooden_cup_water"] = 1,
        ["pmb_stone:cobble"] = 10,
    },
})

minetest.register_node("pmb_stone:cobble_moss_2", {
    description = S("Very Mossy Cobble"),
    groups = {
        full_solid = 1, nature = 1, cobble_moss_2 = 1, oddly_breakable_by_hand = 3,
        solid = 1, suffocates = 2, cracky = 1,    stone = 1, mossy_stone = 1, },
    tiles = { "pmb_stone_cobble.png^pmb_stone_cobble_moss_2.png" },
    drop = "pmb_stone:cobble_moss_2",
    sounds = pmb_sounds.default_stone(),
}) pmb_util.register_all_shapes("pmb_stone:cobble_moss_2")

pmb_tcraft.register_craft({
    output = "pmb_stone:cobble_moss_2 10",
    extra_items = {
        "pmb_items:wooden_cup",
    },
    items = {
        ["pmb_items:wooden_cup_water"] = 1,
        ["pmb_stone:cobble_moss_1"] = 10,
    },
})

minetest.register_node("pmb_stone:obsidian", {
    description = S("Obsidian"),
    groups = {
        full_solid = 1, nature = 1, obsidian = 1, oddly_breakable_by_hand = 3,
        cracky = 4, solid = 1, suffocates = 2, },
    tiles = {"pmb_obsidian.png"},
    sounds = pmb_sounds.default_stone(),
}) pmb_util.register_all_shapes("pmb_stone:obsidian", {}, {remove_groups={"obsidian"}})

pmb_tcraft.register_craft({
    output = "pmb_stone:obsidian 80",
    extra_items = {
        "pmb_elementals:elemental_core_stone",
    },
    items = {
        ["pmb_elementals:elemental_core_stone"] = 1,
        ["pmb_items:iron_nugget"] = 1,
        ["pmb_stone:cobble"] = 80,
    },
})

-- copy an existing node and make it an ore
function pmb_stone.register_ore(in_node, oredef, flags)
    local def = table.copy(minetest.registered_nodes[in_node])
    def.groups = table.copy(def.groups)
    if not def then error(in_node.." is not a real node! Cannot make an ore from it!") end

    flags = flags or {}
    def.groups.natural_stone = nil
    def.description = (oredef.name .. " ore")
    def.drop = oredef.drop
    def.groups["item_"..oredef.ore_id .. "_ore"] = 1
    def.groups.ore = 1

    for group, val in pairs(oredef.groups or {}) do
        def.groups[group] = val
    end
    for group, val in pairs(flags.groups or {}) do
        def.groups[group] = val
    end

    if type(def.tiles[1]) == "table" then
        error(in_node.." does not have simple tiles format.")
    else
        for i, texture in ipairs(def.tiles) do
            def.tiles[i] = texture .. "^" .. oredef.tiles_overlay
        end
    end

    minetest.register_node(in_node .. "_" .. oredef.ore_id .. "_ore", def)
end

pmb_stone.registered_ore_types = {}
function pmb_stone.register_ore_type(ore_id, oredef)
    oredef.ore_id = ore_id
    pmb_stone.registered_ore_types[ore_id] = oredef
end

function pmb_stone.register_ores_for_node(node_name, flags)
    for ore_id, oredef in pairs(pmb_stone.registered_ore_types) do
        pmb_stone.register_ore(node_name, oredef, flags)
    end
end


-- list each ore and its drops so you can batch register them later
pmb_stone.register_ore_type("iron", {
    name = "Iron",
    tiles_overlay = "pmb_iron_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"pmb_items:iron_nugget"},
            },
        },
    },
})
pmb_stone.register_ore_type("tin", {
    name = "Tin",
    tiles_overlay = "pmb_tin_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"pmb_items:tin_nugget"},
            },
        },
    },
})
pmb_stone.register_ore_type("copper", {
    name = "Copper",
    tiles_overlay = "pmb_copper_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"pmb_items:copper_nugget"},
            },
        },
    },
})
pmb_stone.register_ore_type("lapis", {
    name = "Lapis",
    tiles_overlay = "pmb_lapis_overlay.png",
    drop = {
        max_items = 7,
        items = {
            {
                items = {"pmb_items:lapis_lazuli 2"},
            },
            {
                items = {"pmb_items:lapis_lazuli 2"},
                rarity = 2
            },
            {
                items = {"pmb_items:lapis_lazuli 3"},
                rarity = 6
            },
        },
    },
})
pmb_stone.register_ore_type("diamond", {
    name = "Diamond",
    tiles_overlay = "pmb_diamond_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"pmb_items:diamond"},
            },
        },
    },
})
pmb_stone.register_ore_type("coal", {
    name = "Coal",
    tiles_overlay = "pmb_coal_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"pmb_items:coal"},
            },
        },
    },
})
pmb_stone.register_ore_type("gold", {
    name = "Gold",
    tiles_overlay = "pmb_gold_overlay.png",
    drop = {
        max_items = 1,
        items = {
            {
                items = {"pmb_items:gold"},
            },
        },
    },
})

-- make all the ore nodes for these base nodes
pmb_stone.register_ores_for_node("pmb_stone:stone")
pmb_stone.register_ores_for_node("pmb_stone:limestone")
pmb_stone.register_ores_for_node("pmb_stone:sandstone")
pmb_stone.register_ores_for_node("pmb_stone:granite")




minetest.register_node("pmb_stone:bedrock", {
    description = S("Bedrock"),
    groups = {
        full_solid = 1, nature = 1, solid = 1, suffocates = 2, unobtainable = 1 },
    tiles = { "pmb_bedrock.png" },
    drop = "",
    sounds = pmb_sounds.default_stone(),
    sunlight_propagates = true,
    diggable = false,
    on_dig = function(pos, node, digger)
        local name = (digger:is_player() and digger:get_player_name()) or dump(digger)
        minetest.log("\n\n[!!!] Bedrock was dug at " .. tostring(pos) .. " by " .. name .. "\n\n")
    end
})

