local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


local tiles = {{name = "pmb_lights_torch.png",
    backface_culling = false,
    animation = {type="vertical_frames", aspect_w = 16, aspect_h = 16, length = 0.5}
}}

minetest.register_node("pmb_lights:torch", {
    description = S("Torch"),
    light_source = 12,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "aom_torch.b3d",
    use_texture_alpha = "clip",
    tiles = tiles,
    walkable = false,
    groups = { dig_immediate = 3, deco_block = 1, furniture = 1, torch = 1, },
    sounds = pmb_sounds.default_wood(),
    -- paramtype2 = "facedir",
	selection_box = {
		type = "fixed",
		fixed = {-3/16, -8/16, -3/16, 3/16, 0/16, 3/16},
	},
    on_place = function(itemstack, placer, pointed_thing)
        local ret = pmb_util.try_rightclick(itemstack, placer, pointed_thing, false)
        if ret then
            return ret, nil
        end
        local dir = vector.subtract(pointed_thing.under, pointed_thing.above)
        if dir.y == 1 then return itemstack end
        local retpos = nil
        itemstack, retpos = pmb_util.rotate_and_place_against(itemstack, placer, pointed_thing)
        return itemstack
    end,
    _on_node_update = pmb_lights.on_node_update,
    _wall = "pmb_lights:torch_wall",
    _floor = "pmb_lights:torch",
})

minetest.register_node("pmb_lights:torch_wall", {
    description = S("Torch"),
    light_source = 12,
    drawtype = "mesh",
    paramtype = "light",
    sunlight_propagates = true,
    mesh = "aom_torch_wall.b3d",
    use_texture_alpha = "clip",
    tiles = tiles,
    drop = "pmb_lights:torch",
    walkable = false,
    groups = { dig_immediate = 3, deco_block = 1, furniture = 1, torch = 1, },
    sounds = pmb_sounds.default_wood(),
    paramtype2 = "facedir",
	selection_box = {
		type = "fixed",
		fixed = {-3/16, -6/16, 4/16, 3/16, 3/16, 8/16},
	},
    on_place = function(itemstack, placer, pointed_thing)
        return minetest.rotate_and_place(itemstack, placer, pointed_thing, nil, {force_floor=true,})
    end,
    _on_node_update = pmb_lights.on_node_update,
    _wall = "pmb_lights:torch_wall",
    _floor = "pmb_lights:torch",
})

if minetest.get_modpath("pmb_tcraft") then
    pmb_tcraft.register_group_craft({
        output = "pmb_lights:torch 4",
        items = {
            ["pmb_items:stick"] = 4
        },
        group = "coal",
        group_count = 1
    })
end
