
local schems = {}

local sch = pmb_mirecaves.get_schematic_path

local function reg_variant(name)
    schems[#schems+1] = sch(name)
end

reg_variant("nolmer_1")
reg_variant("nolmer_2")
reg_variant("nolmer_3")
reg_variant("nolmer_4")

local function get_variant()
    return schems[(math.random(1, #schems))]
end

local function is_air_above(pos, limit)
    local v = vector.copy(pos)
    for i=1, limit do
      v = vector.offset(v, 0, 1, 0)
      local node = minetest.get_node(v)
      if node.name ~= "air" then
        return false
      end
    end
    return true
  end

local function grow_nolmer(pos, node, active_object_count, active_object_count_wider)
  pmb_util.did_abm("crop")
    if is_air_above(pos, 6) then
        minetest.place_schematic(pos, get_variant(), "random", nil, false, {place_center_x=true, place_center_z=true})
    end
end

-- grow potato
minetest.register_abm({
    nodenames = {"pmb_mirecaves:nolmer_stem"},
    interval = 20.0,
    chance = 80,
    action = grow_nolmer,
})
