local mod_name = minetest.get_current_modname()
local mod_path = minetest.get_modpath(mod_name)
local S = minetest.get_translator(mod_name)


local tiles = {{name = "pmb_lights_lantern.png^[multiply:#eee",
    backface_culling = false,
}}

local lantern_nodes = {
    ["pmb_lights:lantern"] = "pmb_lights:lantern_off",
    ["pmb_lights:lantern_off"] = "pmb_lights:lantern",
    ["pmb_lights:lantern_ceiling"] = "pmb_lights:lantern_off_ceiling",
    ["pmb_lights:lantern_off_ceiling"] = "pmb_lights:lantern_ceiling",
}

local function switch_lantern(pos)
    local node = minetest.get_node(pos)
    local ret = lantern_nodes[node.name]
    if ret then node.name = ret end
    minetest.swap_node(pos, node)
    minetest.sound_play("aom_explosives_lighter", {
        gain = 0.5,
        pos = pos,
        max_hear_distance = 7,
    })
end

for i, def in ipairs({
    {name="lantern", light=14},
    {name="lantern_off", light=6}}) do

    local name = def.name
    local light = def.light
    minetest.register_node("pmb_lights:"..name, {
        description = S("Lantern"),
        light_source = light,
        drawtype = "mesh",
        paramtype = "light",
        sunlight_propagates = true,
        mesh = "aom_lantern.b3d",
        use_texture_alpha = "clip",
        tiles = tiles,
        walkable = false,
        drop = "pmb_lights:lantern",
        groups = { dig_immediate = 3, deco_block = 1, furniture = 1, lantern = 1, },
        sounds = pmb_sounds.default_wood(),
        on_place = function(itemstack, placer, pointed_thing)
            local ret = pmb_util.try_rightclick(itemstack, placer, pointed_thing, false)
            if ret then
                return ret, nil
            end
            if pointed_thing and (not pmb_lights.has_floor(pointed_thing.above)) and (not pmb_lights.has_ceiling(pointed_thing.above)) then
                return itemstack
            else
                return minetest.item_place_node(itemstack, placer, pointed_thing)
            end
        end,
        selection_box = {
            type = "fixed",
            fixed = {-3/16, -8/16, -3/16, 3/16, 0/16, 3/16},
        },
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            switch_lantern(pos)
            return itemstack
        end,
        _lantern_alt = "",
        _on_node_update = pmb_lights.on_node_update,
        _ceiling = "pmb_lights:lantern_ceiling",
        _floor = "pmb_lights:lantern",
        _no_wall = true,
    })

    minetest.register_node("pmb_lights:"..name.."_ceiling", {
        description = S("Lantern"),
        light_source = light,
        drawtype = "mesh",
        paramtype = "light",
        sunlight_propagates = true,
        mesh = "aom_lantern_ceiling.b3d",
        use_texture_alpha = "clip",
        tiles = tiles,
        drop = "pmb_lights:lantern",
        walkable = false,
        groups = { dig_immediate = 3, deco_block = 1, furniture = 1, lantern = 1, },
        sounds = pmb_sounds.default_wood(),
        selection_box = {
            type = "fixed",
            fixed = {-3/16, -8/16, -3/16, 3/16, 0/16, 3/16},
        },
        on_rightclick = function(pos, node, clicker, itemstack, pointed_thing)
            switch_lantern(pos)
            return itemstack
        end,
        _on_node_update = pmb_lights.on_node_update,
        _ceiling = "pmb_lights:lantern_ceiling",
        _floor = "pmb_lights:lantern",
        _no_wall = true,
    })
end

if minetest.get_modpath("pmb_tcraft") then
    pmb_tcraft.register_craft({
        output = "pmb_lights:lantern 4",
        items = {
            ["pmb_items:iron_sheet"] = 1,
            ["pmb_lights:torch"] = 4,
        }
    })
end
